/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import ganymedes01.headcrumbs.api.IHumanEntity;
import ganymedes01.headcrumbs.utils.CapeUtils;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureUtils {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");

    public static ResourceLocation getPlayerSkin(IHumanEntity human) {
        return TextureUtils.getTextureForHuman(human, MinecraftProfileTexture.Type.SKIN);
    }

    public static ResourceLocation getPlayerCape(IHumanEntity human) {
        return TextureUtils.getTextureForHuman(human, MinecraftProfileTexture.Type.CAPE);
    }

    private static ResourceLocation getTextureForHuman(IHumanEntity human, MinecraftProfileTexture.Type type) {
        ResourceLocation cape;
        if (human.isTextureAvailable(type)) {
            return human.getTexture(type);
        }
        if (!human.isProfileReady()) {
            return TextureUtils.getDefault(human.getProfile(), type);
        }
        GameProfile profile = human.getProfile();
        if (type == MinecraftProfileTexture.Type.CAPE && (cape = CapeUtils.getCape(profile)) != null) {
            human.getCallback().func_180521_a(type, cape, null);
            return cape;
        }
        return TextureUtils.getPlayerTexture(profile, type, human.getCallback());
    }

    private static ResourceLocation getPlayerTexture(GameProfile profile, MinecraftProfileTexture.Type type, SkinManager.SkinAvailableCallback callBack) {
        Minecraft minecraft;
        Map map;
        if (profile != null && profile.getName() != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(profile)).containsKey(type)) {
            return minecraft.func_152342_ad().func_152789_a((MinecraftProfileTexture)map.get(type), type, callBack);
        }
        return TextureUtils.getDefault(profile, type);
    }

    public static ResourceLocation getDefault(GameProfile profile, MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.CAPE) {
            return null;
        }
        String skinType = TextureUtils.getPlayerSkinType(profile);
        if ("slim".equals(skinType)) {
            return TEXTURE_ALEX;
        }
        return TEXTURE_STEVE;
    }

    public static String getPlayerSkinType(GameProfile profile) {
        Minecraft minecraft;
        Map map;
        String type = null;
        if (profile != null && profile.getName() != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            type = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
        }
        if (type == null) {
            type = "default";
        }
        return type;
    }
}

