/*
 * Decompiled with CFR 0.152.
 */
package net.flawedlogic.wildcrops.worldgen;

import java.util.Random;
import net.flawedlogic.wildcrops.WildCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WildCropWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        int xCh = chunkX * 16 + 8;
        int yCh = random.nextInt(128);
        int zCh = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(xChunk + 16, 0, zChunk + 16));
        BlockPos randomPos = new BlockPos(xCh, yCh + 64, zCh);
        BlockPos minPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BlockPos centerPos = new BlockPos(xChunk, 0, zChunk);
        BlockPos maxPos = new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16);
        if (random.nextInt(100) <= WildCrops.proxy.wildCropsSpawnChance) {
            this.generateWildCrop(world, random, minPos, maxPos, centerPos, randomPos);
        }
    }

    private void generateWildCrop(World world, Random random, BlockPos minPos, BlockPos maxPos, BlockPos centerPos, BlockPos randomPos) {
        int i;
        Block seedBlock = null;
        int cropSize = random.nextInt(WildCrops.proxy.wildCropsMaxPatchSize);
        if (cropSize < WildCrops.proxy.wildCropsMinPatchSize) {
            cropSize = WildCrops.proxy.wildCropsMinPatchSize;
        }
        BlockPos[] cropPositions = new BlockPos[cropSize];
        cropPositions[0] = randomPos;
        for (i = 1; i < cropSize; ++i) {
            cropPositions[i] = this.getRandomPosition(cropPositions[i - 1], random);
        }
        for (i = 0; i < cropPositions.length; ++i) {
            Block block;
            BlockPos newPos = world.func_175672_r(cropPositions[i]);
            IBlockState soil = world.func_180495_p(newPos.func_177977_b());
            if (world.func_180495_p(newPos).func_185904_a().func_76224_d() || !WildCrops.proxy.wildCrops.containsKey(soil.func_177230_c())) continue;
            Block[] cropBlocks = WildCrops.proxy.wildCrops.get(soil.func_177230_c());
            if (WildCrops.proxy.wildCropsOneCropPerSpawn.booleanValue()) {
                if (seedBlock == null) {
                    seedBlock = this.getRandomCrop(cropBlocks, random);
                }
                block = seedBlock;
            } else {
                block = this.getRandomCrop(cropBlocks, random);
            }
            if (block == null) continue;
            if (block instanceof BlockCrops) {
                BlockCrops blockCrop = (BlockCrops)block;
                int fullGrownMeta = blockCrop.func_185526_g();
                world.func_180501_a(newPos, blockCrop.func_176203_a(MathHelper.func_76136_a((Random)random, (int)(fullGrownMeta / 2 - 1), (int)fullGrownMeta)), 2);
                world.func_180501_a(newPos.func_177977_b(), Blocks.field_150458_ak.func_176223_P(), 2);
                continue;
            }
            world.func_180501_a(newPos, block.func_176223_P(), 2);
            world.func_180501_a(newPos.func_177977_b(), Blocks.field_150458_ak.func_176223_P(), 2);
        }
    }

    private Block getRandomCrop(Block[] cropBlocks, Random random) {
        return cropBlocks[random.nextInt(cropBlocks.length)];
    }

    private BlockPos getRandomPosition(BlockPos start, Random rand) {
        BlockPos newPos = new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p());
        int randomNess = rand.nextInt(5);
        for (int i = 0; i < randomNess; ++i) {
            int direction = rand.nextInt(4);
            switch (direction) {
                case 0: {
                    newPos = newPos.func_177978_c();
                }
                case 1: {
                    newPos = newPos.func_177968_d();
                }
                case 2: {
                    newPos = newPos.func_177976_e();
                }
                case 3: {
                    newPos = newPos.func_177974_f();
                }
            }
        }
        return newPos;
    }
}

