/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.api;

import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BackpackHelper {
    public static double INTERACT_MAX_DISTANCE = 1.8;
    public static double INTERACT_MAX_ANGLE = 110.0;
    public static boolean equipAsChestArmor = true;
    public static Logger LOG = LogManager.getLogger((String)"wearablebackpacks:api");

    private BackpackHelper() {
    }

    public static IBackpack getBackpack(Entity entity) {
        if (entity == null) {
            return null;
        }
        IBackpack backpack = (IBackpack)entity.getCapability(IBackpack.CAPABILITY, null);
        return backpack != null && !backpack.getStack().func_190926_b() ? backpack : null;
    }

    public static IBackpack getBackpack(TileEntity entity) {
        return entity != null ? (IBackpack)entity.getCapability(IBackpack.CAPABILITY, null) : null;
    }

    public static IBackpackType getBackpackType(ItemStack stack) {
        return !stack.func_190926_b() ? BackpackHelper.getBackpackType(stack.func_77973_b()) : null;
    }

    public static IBackpackType getBackpackType(Item item) {
        return item instanceof IBackpackType ? (IBackpackType)item : null;
    }

    public static boolean canEquipBackpack(EntityLivingBase entity) {
        return entity.getCapability(IBackpack.CAPABILITY, null) != null && BackpackHelper.getBackpack((Entity)entity) == null && (!equipAsChestArmor || !(entity instanceof EntityPlayer) || entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b());
    }

    public static void setEquippedBackpack(EntityLivingBase entity, ItemStack stack, IBackpackData backpackData) {
        IBackpackType backpackType = BackpackHelper.getBackpackType(stack);
        if (!stack.func_190926_b() && backpackType == null) {
            throw new IllegalArgumentException("Backpack item isn't an IBackpackType.");
        }
        IBackpack backpack = (IBackpack)entity.getCapability(IBackpack.CAPABILITY, null);
        backpack.setStack(stack);
        backpack.setData(backpackData);
    }

    public static boolean canInteractWithEquippedBackpack(EntityPlayer player, EntityLivingBase carrier) {
        IBackpack backpack = BackpackHelper.getBackpack((Entity)carrier);
        if (backpack == null || !player.func_70089_S() || !carrier.func_70089_S()) {
            return false;
        }
        if (player == carrier) {
            return true;
        }
        double distance = player.func_70032_d((Entity)carrier);
        double angle = Math.toDegrees(Math.atan2(carrier.field_70161_v - player.field_70161_v, carrier.field_70165_t - player.field_70165_t));
        angle = ((angle - (double)carrier.field_70761_aq - 90.0) % 360.0 + 540.0) % 360.0 - 180.0;
        return distance <= INTERACT_MAX_DISTANCE && Math.abs(angle) < INTERACT_MAX_ANGLE / 2.0;
    }

    public static boolean equipBackpack(EntityLivingBase entity, TileEntity tileEntity) {
        if (tileEntity == null || !BackpackHelper.canEquipBackpack(entity)) {
            return false;
        }
        IBackpack backpack = (IBackpack)tileEntity.getCapability(IBackpack.CAPABILITY, null);
        if (backpack == null) {
            return false;
        }
        ItemStack stack = backpack.getStack();
        IBackpackType type = BackpackHelper.getBackpackType(stack);
        if (type == null) {
            return false;
        }
        type.onEquip(entity, tileEntity, backpack);
        if (!entity.field_70170_p.field_72995_K) {
            BackpackHelper.setEquippedBackpack(entity, stack, backpack.getData());
            backpack.setStack(ItemStack.field_190927_a);
            backpack.setData(null);
        }
        return true;
    }

    public static boolean placeBackpack(World world, BlockPos pos, ItemStack stack, EntityLivingBase entity, boolean ignoreEntities) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player != null && !player.func_175151_a(pos, EnumFacing.UP, stack)) {
            return false;
        }
        Item item = stack.func_77973_b();
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)item.getRegistryName());
        if (ignoreEntities ? !block.func_176196_c(world, pos) : !world.func_190527_a(block, pos, false, EnumFacing.UP, null)) {
            return false;
        }
        IBlockState state = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.5f, 0.5f, 0.5f, item.func_77647_b(stack.func_77960_j()), (EntityLivingBase)player, EnumHand.MAIN_HAND);
        if (!world.func_180501_a(pos, state, 3) || world.func_180495_p(pos).func_177230_c() != block) {
            return false;
        }
        block.func_180633_a(world, pos, state, entity, stack);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        SoundType sound = block.getSoundType(state, world, pos, (Entity)entity);
        world.func_184134_a(x, y, z, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f, false);
        boolean alreadyConfigured = ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return true;
        }
        IBackpack placedBackpack = BackpackHelper.getBackpack(tileEntity);
        if (placedBackpack == null) {
            return true;
        }
        IBackpack carrierBackpack = BackpackHelper.getBackpack((Entity)entity);
        boolean isEquipped = carrierBackpack != null && carrierBackpack.getStack() == stack;
        ItemStack stackOrig = stack;
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            stack.func_77978_p().func_82580_o("BlockEntityTag");
        }
        placedBackpack.setStack(stack);
        if (!alreadyConfigured) {
            if (isEquipped) {
                IBackpackType type = carrierBackpack.getType();
                IBackpackData data = carrierBackpack.getData();
                if (data == null && !world.field_72995_K) {
                    LOG.error("Backpack data was null when placing down equipped backpack");
                    data = type.createBackpackData(stack);
                }
                placedBackpack.setData(data);
                if (!world.field_72995_K) {
                    BackpackHelper.setEquippedBackpack(entity, ItemStack.field_190927_a, null);
                }
                type.onUnequip(entity, tileEntity, placedBackpack);
            } else if (!world.field_72995_K) {
                placedBackpack.setData(placedBackpack.getType().createBackpackData(stack));
            }
        }
        stackOrig.func_190918_g(1);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateLidTicks(IBackpack properties, double x, double y, double z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        boolean usedByPlayer = properties.getPlayersUsing() > 0;
        int prevLidTicks = properties.getLidTicks();
        IBackpackType backpackType = BackpackHelper.getBackpackType(properties.getStack());
        int maxLidTicks = backpackType != null ? backpackType.getLidMaxTicks() : 0;
        int lidTicks = Math.max(-1, Math.min(maxLidTicks, prevLidTicks + (usedByPlayer ? 1 : -1)));
        properties.setLidTicks(lidTicks);
        if (lidTicks > 0 && prevLidTicks <= 0) {
            world.func_184134_a(x, y, z, SoundEvents.field_187807_fF, SoundCategory.PLAYERS, 1.0f, 0.6f, false);
        }
        if (lidTicks < maxLidTicks / 5 && prevLidTicks >= maxLidTicks / 5) {
            world.func_184134_a(x, y, z, SoundEvents.field_187807_fF, SoundCategory.PLAYERS, 0.8f, 0.4f, false);
        }
    }
}

