/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mcft.copy.backpacks.client.gui.Alignment;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiContainerScreen;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiLabel;
import net.mcft.copy.backpacks.client.gui.GuiLayout;
import net.mcft.copy.backpacks.client.gui.GuiScrollable;
import net.mcft.copy.backpacks.client.gui.config.BaseEntry;
import net.mcft.copy.backpacks.client.gui.config.IConfigEntry;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.client.gui.control.GuiButtonGlyph;
import net.mcft.copy.backpacks.config.Setting;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseConfigScreen
extends GuiContainerScreen {
    private final List<GuiLabel> _titleLabels;
    public final GuiScreen parentScreen;
    protected final GuiLayout layoutMain;
    protected final GuiLayout layoutTitle;
    protected final EntryListScrollable scrollableContent;
    protected final EntryList listEntries;
    protected final GuiLayout layoutButtons;
    protected final GuiButton buttonDone;
    protected final GuiButton buttonReset;
    protected final GuiButton buttonUndo;

    public BaseConfigScreen(GuiScreen parentScreen, String ... titleLines) {
        this.parentScreen = parentScreen;
        this.layoutMain = new GuiLayout(Direction.VERTICAL);
        this.layoutMain.setFill();
        this.layoutMain.setSpacing(0);
        this.layoutTitle = new GuiLayout(Direction.VERTICAL);
        this.layoutTitle.setFillHorizontal();
        this.layoutTitle.setPaddingVertical(7);
        this.layoutTitle.setSpacing(1);
        this._titleLabels = Arrays.stream(titleLines).filter(Objects::nonNull).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).map(GuiLabel::new).collect(Collectors.toList());
        this._titleLabels.forEach(GuiElementBase::setCenteredHorizontal);
        this._titleLabels.forEach(this.layoutTitle::addFixed);
        this.listEntries = new EntryList();
        this.scrollableContent = new EntryListScrollable(this.listEntries);
        this.layoutButtons = new GuiLayout(Direction.HORIZONTAL);
        this.layoutButtons.setCenteredHorizontal();
        this.layoutButtons.setPaddingVertical(3, 9);
        this.layoutButtons.setSpacing(5);
        this.buttonDone = new GuiButton(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.buttonUndo = new GuiButtonGlyph("\u21b6", I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]));
        this.buttonReset = new GuiButtonGlyph("\u2604", I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]));
        if (this.buttonDone.getWidth() < 100) {
            this.buttonDone.setWidth(100);
        }
        this.buttonDone.setAction(this::doneClicked);
        this.buttonUndo.setAction(this::undoChanges);
        this.buttonReset.setAction(this::setToDefault);
        this.layoutMain.addFixed(this.layoutTitle);
        this.layoutMain.addWeighted(this.scrollableContent);
        this.layoutMain.addFixed(this.layoutButtons);
        this.container.add(this.layoutMain);
    }

    public void addEntry(GuiElementBase entry) {
        this.listEntries.addFixed(entry);
    }

    public List<String> getTitleLines() {
        return Collections.unmodifiableList(this._titleLabels.stream().map(GuiLabel::getText).collect(Collectors.toList()));
    }

    public int getTitleLineCount() {
        return this._titleLabels.size();
    }

    public void setTitleLine(int index, String value) {
        this._titleLabels.get(index).setText(I18n.func_135052_a((String)value, (Object[])new Object[0]));
    }

    public boolean isChanged() {
        return this.listEntries.getEntries().anyMatch(IConfigEntry::isChanged);
    }

    public boolean isDefault() {
        return this.listEntries.getEntries().allMatch(IConfigEntry::isDefault);
    }

    public boolean isValid() {
        return this.listEntries.getEntries().allMatch(IConfigEntry::isValid);
    }

    public void undoChanges() {
        this.listEntries.getEntries().forEach(IConfigEntry::undoChanges);
    }

    public void setToDefault() {
        this.listEntries.getEntries().forEach(IConfigEntry::setToDefault);
    }

    public Setting.ChangeRequiredAction applyChanges() {
        return this.listEntries.getEntries().map(e -> e.applyChanges()).max(Enum::compareTo).orElse(Setting.ChangeRequiredAction.None);
    }

    protected void doneClicked() {
        GuiElementBase.display(this.parentScreen);
    }

    public static class EntryList
    extends GuiLayout {
        public int maxLabelWidth;
        public int maxElementWidth;

        public EntryList() {
            super(Direction.VERTICAL);
            this.setCenteredHorizontal();
            this.setPaddingVertical(4, 3);
            this.setExpand(Direction.HORIZONTAL, false);
        }

        @Override
        protected void updateChildSizes(Direction direction) {
            super.updateChildSizes(direction);
            this.maxLabelWidth = this.getEntryLabels().mapToInt(GuiElementBase::getWidth).max().orElse(0);
            this.getEntryLabels().forEach(l -> l.setWidth(this.maxLabelWidth));
            this.maxElementWidth = this.getElements().filter(e -> !(e.getAlign(Direction.HORIZONTAL) instanceof Alignment.Both)).mapToInt(GuiElementBase::getWidth).max().orElse(0);
        }

        public Stream<GuiElementBase> getElements() {
            return this.children.stream();
        }

        public Stream<IConfigEntry> getEntries() {
            return this.getElements().filter(IConfigEntry.class::isInstance).map(IConfigEntry.class::cast);
        }

        public Stream<GuiLabel> getEntryLabels() {
            return this.getElements().filter(BaseEntry.class::isInstance).map(BaseEntry.class::cast).filter(BaseEntry::hasLabel).map(entry -> entry.label);
        }
    }

    public static class EntryListScrollable
    extends GuiScrollable {
        public EntryList entryList;

        public EntryListScrollable(EntryList entryList) {
            super(Direction.VERTICAL);
            this.setFillHorizontal();
            this.getScrollbar().setAlign(Direction.HORIZONTAL, (Alignment)new GuiScrollable.ContentMax(4));
            this.entryList = entryList;
            this.add(this.entryList);
        }

        @Override
        protected void updateChildSizes(Direction direction) {
            super.updateChildSizes(direction);
            if (direction != Direction.HORIZONTAL || this.entryList == null) {
                return;
            }
            int minimumWidth = this.entryList.maxElementWidth;
            int dynamicWidth = this.entryList.maxLabelWidth + 8 + this.getWidth() / 2;
            this.entryList.setWidth(Math.max(minimumWidth, dynamicWidth));
        }
    }
}

