/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.config.BackpacksConfigScreen;
import net.mcft.copy.backpacks.client.gui.config.BaseEntry;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.config.Setting;
import net.mcft.copy.backpacks.config.Status;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntryCategory
extends BaseEntry {
    public static final int BUTTON_WIDTH = 300;
    public final String category;
    public final BackpacksConfigScreen childScreen;

    public EntryCategory(BackpacksConfigScreen owningScreen, String category) {
        this.category = category;
        GuiButton button = new GuiButton(300);
        button.setText(I18n.func_135052_a((String)this.getLanguageKey(), (Object[])new Object[0]));
        button.setTooltip(this.getCategoryTooltip());
        button.setAction(this::onButtonPressed);
        this.setSpacing(0, 6, 4);
        this.addWeighted(new GuiContainer());
        this.addFixed(button);
        this.addFixed(this.buttonUndo);
        this.addFixed(this.buttonReset);
        this.childScreen = new BackpacksConfigScreen((GuiScreen)owningScreen, this);
    }

    public String getLanguageKey() {
        return "config.wearablebackpacks.category." + this.category;
    }

    private List<String> getCategoryTooltip() {
        String langKey = this.getLanguageKey();
        return this.formatTooltip(langKey, langKey + ".tooltip", null, null);
    }

    @Override
    public List<Status> getStatus() {
        return this.childScreen.isValid() ? Collections.emptyList() : Arrays.asList(Status.INVALID);
    }

    protected void onButtonPressed() {
        EntryCategory.display(this.childScreen);
    }

    @Override
    public boolean isChanged() {
        return this.childScreen.isChanged();
    }

    @Override
    public boolean isDefault() {
        return this.childScreen.isDefault();
    }

    @Override
    public void undoChanges() {
        this.childScreen.undoChanges();
    }

    @Override
    public void setToDefault() {
        this.childScreen.setToDefault();
    }

    @Override
    public Setting.ChangeRequiredAction applyChanges() {
        return this.childScreen.applyChanges();
    }
}

