/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.Optional;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class EntryValueButton<T>
extends GuiButton
implements IConfigValue<T> {
    protected T value;

    public EntryValueButton() {
        this.setHeight(18);
    }

    @Override
    public Optional<T> getValue() {
        return Optional.of(this.value);
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.setText(this.getButtonText(value));
    }

    protected String getButtonText(T value) {
        return value.toString();
    }

    public static class Switch
    extends EntryValueButton<Boolean> {
        @Override
        public void onPressed(int mouseX, int mouseY) {
            this.setValue((Boolean)this.value == false);
        }

        @Override
        protected String getButtonText(Boolean value) {
            return (value != false ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED) + super.getButtonText(value);
        }
    }
}

