/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.List;
import java.util.Optional;
import net.mcft.copy.backpacks.client.gui.config.IConfigValue;
import net.mcft.copy.backpacks.client.gui.control.GuiField;
import net.mcft.copy.backpacks.config.Status;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class EntryValueField<T>
extends GuiField
implements IConfigValue<T>,
IConfigValue.ShowsStatus {
    public EntryValueField() {
        this.setHeight(18);
    }

    @Override
    public Optional<T> getValue() {
        try {
            return Optional.of(this.parseValue(this.getText()));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Override
    public void setValue(T value) {
        if (!this.getValue().equals(Optional.of(value))) {
            this.setText(this.stringifyValue(value));
        }
    }

    @Override
    public void setStatus(List<Status> value) {
        Status.Severity severity = Status.getSeverity(value);
        boolean isFine = Status.Severity.HINT.compareTo(severity) >= 0;
        this.setTextColor(!isFine ? severity.foregroundColor : -2039584);
        this.setBorderColor(!isFine ? severity.foregroundColor : -6250336);
    }

    protected abstract T parseValue(String var1);

    protected String stringifyValue(T value) {
        return value.toString();
    }

    public static class Decimal
    extends EntryValueField<Double> {
        @Override
        protected Double parseValue(String text) {
            return Double.parseDouble(text);
        }

        @Override
        protected boolean isCharValid(char chr) {
            String validChars = "0123456789";
            return validChars.contains(String.valueOf(chr)) || chr == '-' && this.getCursorPosition() == 0 && !this.getText().startsWith("-") || chr == '.' && !this.getText().contains(".");
        }
    }

    public static class Number
    extends EntryValueField<Integer> {
        @Override
        protected Integer parseValue(String text) {
            return Integer.parseInt(text);
        }

        @Override
        protected boolean isCharValid(char chr) {
            String validChars = "0123456789";
            return validChars.contains(String.valueOf(chr)) || chr == '-' && this.getCursorPosition() == 0 && !this.getText().startsWith("-");
        }
    }

    public static class Text
    extends EntryValueField<String> {
        @Override
        protected String parseValue(String text) {
            return text;
        }
    }
}

