/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import com.google.common.collect.Sets;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.common.Dependencies;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.api.UniDictAPI;
import wanion.unidict.common.Reference;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceContainer;

public final class UniResourceHandler {
    private static final TIntSet kindJEIBlackSet = new TIntHashSet();
    private final Map<String, Resource> apiResourceMap = new THashMap();
    private final Map<String, Resource> resourceMap = new THashMap();
    private final Dependencies<UniDict.IDependency> dependencies = UniDict.getDependencies();
    private final Config config = UniDict.getConfig();

    public void preInit() {
        this.dependencies.subscribe((Dependencies.DependenceWatcher)new Dependencies.DependenceWatcher<UniDictAPI>(this.dependencies){

            @Nonnull
            public UniDictAPI instantiate() {
                return new UniDictAPI(Collections.unmodifiableMap(UniResourceHandler.this.apiResourceMap));
            }
        });
        this.dependencies.subscribe((Dependencies.DependenceWatcher)new Dependencies.DependenceWatcher<ResourceHandler>(this.dependencies){

            @Nonnull
            public ResourceHandler instantiate() {
                return new ResourceHandler(Collections.unmodifiableMap(UniResourceHandler.this.resourceMap));
            }
        });
    }

    static synchronized TIntSet getKindJEIBlackSet() {
        if (kindJEIBlackSet.isEmpty()) {
            UniDict.getConfig().hideInJEIKindBlackSet.forEach(blackKind -> kindJEIBlackSet.add(Resource.getKindFromName(blackKind)));
        }
        return kindJEIBlackSet;
    }

    static Set<String> getEntryJEIBlackSet() {
        return UniDict.getConfig().hideInJEIEntryBlackSet;
    }

    public void init(FMLInitializationEvent event) {
        this.customEntries();
        this.gatherResources();
        this.createAdditionalFiles();
        this.updateEntries((FMLStateEvent)event);
        this.createDumps();
    }

    private void customEntries() {
        this.config.userOreDictEntries.forEach(customEntries -> {
            String itemName;
            int separatorChar;
            Item item;
            String oreName;
            List<ItemStack> oreList;
            int plusSeparator = customEntries.indexOf(43);
            int minusSeparator = customEntries.indexOf(45);
            if (plusSeparator > 0) {
                String itemName2 = customEntries.substring(plusSeparator + 1);
                int separatorChar2 = itemName2.indexOf(35);
                Item item2 = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(separatorChar2 == -1 ? itemName2 : itemName2.substring(0, separatorChar2)));
                if (item2 != null) {
                    try {
                        int metadata = separatorChar2 == -1 ? 0 : Integer.parseInt(itemName2.substring(separatorChar2 + 1, itemName2.length()));
                        OreDictionary.registerOre((String)customEntries.substring(0, plusSeparator), (ItemStack)new ItemStack(item2, 1, metadata));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            } else if (minusSeparator > 0 && (oreList = UniOreDictionary.get(oreName = customEntries.substring(0, minusSeparator))) != null && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((separatorChar = (itemName = customEntries.substring(minusSeparator + 1)).indexOf(35)) == -1 ? itemName : itemName.substring(0, separatorChar)))) != null) {
                int metaData = separatorChar == -1 ? 0 : Integer.parseInt(itemName.substring(separatorChar + 1, itemName.length()));
                ItemStack itemStack = new ItemStack(item, 1, metaData);
                boolean found = false;
                Iterator<ItemStack> itemStackIterator = oreList.iterator();
                while (!found && itemStackIterator.hasNext()) {
                    found = itemStack.func_77969_a(itemStackIterator.next());
                    if (!found) continue;
                    itemStackIterator.remove();
                }
            }
        });
    }

    private void gatherResources() {
        List allTheResourceNames = Collections.synchronizedList(new ArrayList());
        Pattern resourceBlackTagsPattern = Pattern.compile(".*(?i)(Brick|Dense|Nether|Dye|Glass|Tiny|Small|Slime|Coralium|Fuel|Certus|ChargedCertus|ore|Redstone).*");
        ((Stream)UniOreDictionary.getThoseThatMatches("^ingot").parallelStream().filter(matcher -> !resourceBlackTagsPattern.matcher(matcher.replaceFirst("")).find()).sequential()).forEach(matcher -> allTheResourceNames.add(WordUtils.capitalize((String)matcher.replaceFirst(""))));
        StringBuilder patternBuilder = new StringBuilder("(");
        Iterator allTheResourceNamesIterator = allTheResourceNames.iterator();
        while (allTheResourceNamesIterator.hasNext()) {
            patternBuilder.append((String)allTheResourceNamesIterator.next()).append(allTheResourceNamesIterator.hasNext() ? "|" : ")$");
        }
        HashMap<String, Set> basicResourceMap = new HashMap<String, Set>();
        LinkedHashSet allTheKinds = new LinkedHashSet();
        HashSet allTheKindsBlackSet = Sets.newHashSet((Object[])new String[]{"blockFuel", "blockPrudentium", "trapdoor", "oreChargedCertus", "slabNether", "bucketDust", "oreCoralium", "sapling", "pulp", "item", "stone", "wood", "bottleLiquid", "quartz", "mana", "crafter", "material", "leaves", "oreCertus", "crystalSHard", "eternalLife", "blockPrismarine", "bells", "enlightenedFused", "darkFused", "crystalShard", "food", "hardened", "blockPsi", "blockStainedHardened", "rubber", "scaffoldingTreated", "fenceGate", "oc:stone", "calculatorReinforced"});
        UniOreDictionary.getThoseThatMatches(Pattern.compile(patternBuilder.toString())).forEach(matcher -> {
            String kindName = matcher.replaceFirst("");
            if (!allTheKindsBlackSet.contains(kindName)) {
                String resourceName = matcher.group();
                if (!basicResourceMap.containsKey(resourceName)) {
                    basicResourceMap.put(resourceName, new LinkedHashSet());
                }
                ((Set)basicResourceMap.get(resourceName)).add(kindName);
                allTheKinds.add(kindName);
            }
        });
        allTheKinds.forEach(Resource::register);
        basicResourceMap.forEach((resourceName, kinds) -> {
            TIntObjectHashMap kindMap = new TIntObjectHashMap();
            kinds.forEach(kindName -> {
                int kind = Resource.getKindFromName(kindName);
                kindMap.put(kind, (Object)new UniResourceContainer(kindName + resourceName, kind));
            });
            this.apiResourceMap.put((String)resourceName, new Resource((String)resourceName, (TIntObjectMap<UniResourceContainer>)kindMap));
        });
        if (!this.config.libraryMode) {
            TIntList kindList = Resource.kindNamesToKindList(this.config.childrenOfMetals.toArray(new String[this.config.childrenOfMetals.size()]));
            this.config.metalsToUnify.stream().filter(this.apiResourceMap::containsKey).forEach(resourceName -> this.resourceMap.put((String)resourceName, this.apiResourceMap.get(resourceName).filteredClone(kindList).setSortOfChildren(true)));
            if (!this.config.customUnifiedResources.isEmpty()) {
                this.config.customUnifiedResources.forEach((resourceName, kinds) -> {
                    Resource customResource = this.resourceMap.containsKey(resourceName) ? this.resourceMap.get(resourceName) : new Resource((String)resourceName);
                    kinds.forEach(kindName -> {
                        String oreDictName = kindName + resourceName;
                        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
                            customResource.addChild(new UniResourceContainer(oreDictName, Resource.registerAndGet(kindName), true));
                        }
                    });
                    if (!this.resourceMap.containsKey(resourceName) && customResource.getChildrenCount() != 0) {
                        this.resourceMap.put((String)resourceName, customResource);
                    }
                });
            }
        }
        this.config.saveIfHasChanged();
    }

    private void createAdditionalFiles() {
        if (!this.config.enableSpecificEntrySort && !this.config.enableSpecificKindSort) {
            return;
        }
        File jsonFormatGuideFile = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "jsonFormatGuide.txt");
        if (jsonFormatGuideFile.exists()) {
            return;
        }
        try {
            if (!jsonFormatGuideFile.createNewFile()) {
                UniDict.getLogger().error("UniDict couldn't create the jsonFormatGuide.txt file.");
                return;
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(jsonFormatGuideFile));){
                bw.write("In order to use specificEntrySorting.json you must use the following format:");
                bw.newLine();
                bw.newLine();
                bw.write("[");
                bw.newLine();
                bw.write("\t{");
                bw.newLine();
                bw.write("\t\t\"entryName\" : \"oreCopper\",");
                bw.newLine();
                bw.write("\t\t\"modIdPriorityList\" :");
                bw.newLine();
                bw.write("\t\t[");
                bw.newLine();
                bw.write("\t\t\t\"minecraft\",");
                bw.newLine();
                bw.write("\t\t\t\"thermalfoundation\",");
                bw.newLine();
                bw.write("\t\t\t\"substratum\",");
                bw.newLine();
                bw.write("\t\t\t\"ic2\",");
                bw.newLine();
                bw.write("\t\t\t\"mekanism\",");
                bw.newLine();
                bw.write("\t\t\t\"immersiveengineering\",");
                bw.newLine();
                bw.write("\t\t\t\"techreborn\"");
                bw.newLine();
                bw.write("\t\t]");
                bw.newLine();
                bw.write("\t},");
                bw.newLine();
                bw.write("\t{");
                bw.newLine();
                bw.write("\t\t\"entryName\" : \"oreIron\",");
                bw.newLine();
                bw.write("\t\t\"modIdPriorityList\" :");
                bw.newLine();
                bw.write("\t\t[");
                bw.newLine();
                bw.write("\t\t\t\"minecraft\",");
                bw.newLine();
                bw.write("\t\t\t\"thermalfoundation\",");
                bw.newLine();
                bw.write("\t\t\t\"substratum\",");
                bw.newLine();
                bw.write("\t\t\t\"ic2\",");
                bw.newLine();
                bw.write("\t\t\t\"mekanism\",");
                bw.newLine();
                bw.write("\t\t\t\"immersiveengineering\",");
                bw.newLine();
                bw.write("\t\t\t\"techreborn\"");
                bw.newLine();
                bw.write("\t\t]");
                bw.newLine();
                bw.write("\t}");
                bw.newLine();
                bw.write("]");
                bw.newLine();
                bw.newLine();
                bw.write("In order to use specificKindSorting.json you must use the following format:");
                bw.newLine();
                bw.newLine();
                bw.write("[");
                bw.newLine();
                bw.write("\t{");
                bw.newLine();
                bw.write("\t\t\"kindName\" : \"ore\",");
                bw.newLine();
                bw.write("\t\t\"modIdPriorityList\" :");
                bw.newLine();
                bw.write("\t\t[");
                bw.newLine();
                bw.write("\t\t\t\"minecraft\",");
                bw.newLine();
                bw.write("\t\t\t\"thermalfoundation\",");
                bw.newLine();
                bw.write("\t\t\t\"substratum\",");
                bw.newLine();
                bw.write("\t\t\t\"ic2\",");
                bw.newLine();
                bw.write("\t\t\t\"mekanism\",");
                bw.newLine();
                bw.write("\t\t\t\"immersiveengineering\",");
                bw.newLine();
                bw.write("\t\t\t\"techreborn\"");
                bw.newLine();
                bw.write("\t\t]");
                bw.newLine();
                bw.write("\t},");
                bw.newLine();
                bw.write("\t{");
                bw.newLine();
                bw.write("\t\t\"kindName\" : \"ingot\",");
                bw.newLine();
                bw.write("\t\t\"modIdPriorityList\" :");
                bw.newLine();
                bw.write("\t\t[");
                bw.newLine();
                bw.write("\t\t\t\"minecraft\",");
                bw.newLine();
                bw.write("\t\t\t\"thermalfoundation\",");
                bw.newLine();
                bw.write("\t\t\t\"substratum\",");
                bw.newLine();
                bw.write("\t\t\t\"ic2\",");
                bw.newLine();
                bw.write("\t\t\t\"mekanism\",");
                bw.newLine();
                bw.write("\t\t\t\"immersiveengineering\",");
                bw.newLine();
                bw.write("\t\t\t\"techreborn\"");
                bw.newLine();
                bw.write("\t\t]");
                bw.newLine();
                bw.write("\t}");
                bw.newLine();
                bw.write("]");
                bw.newLine();
                bw.newLine();
                bw.write("NOTE: specific Entry Sorting always will have a higher priority over specific Kind Sorting.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    private void updateEntries(FMLStateEvent event) {
        this.apiResourceMap.values().parallelStream().forEach(Resource::updateEntries);
        if (!this.config.libraryMode) {
            for (String customEntry : this.config.customUnifiedResources.keySet()) {
                Resource customResource = this.resourceMap.get(customEntry);
                if (customResource == null) continue;
                customResource.updateEntries();
            }
            if (this.config.keepOneEntry) {
                OreDictionary.rebakeMap();
            }
            ((ResourceHandler)this.dependencies.get(ResourceHandler.class)).populateIndividualStackAttributes(event);
        }
        for (String blackListedResource : this.config.resourceBlackList) {
            this.resourceMap.remove(blackListedResource);
            this.apiResourceMap.remove(blackListedResource);
        }
    }

    private void createDumps() {
        block56: {
            if (this.config.kindsDump || this.config.entriesDump || this.config.unifiedEntriesDump) {
                File dumpFolder = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "dump");
                if (!dumpFolder.exists() && dumpFolder.mkdirs()) {
                    UniDict.getLogger().error("UniDict wasn't able to create the dump folder.");
                }
                if (dumpFolder.exists()) {
                    Throwable throwable;
                    BufferedWriter bw;
                    block55: {
                        block54: {
                            if (this.config.kindsDump) {
                                File kindDumpFile = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "dump" + Reference.SLASH + "kindsDump.txt");
                                try {
                                    if (!kindDumpFile.createNewFile()) break block54;
                                    try {
                                        bw = new BufferedWriter(new FileWriter(kindDumpFile));
                                        throwable = null;
                                        try {
                                            Resource.getKinds().forEach(kind -> {
                                                try {
                                                    bw.write((String)kind);
                                                    bw.newLine();
                                                }
                                                catch (IOException e) {
                                                    e.printStackTrace();
                                                }
                                            });
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            if (bw != null) {
                                                if (throwable != null) {
                                                    try {
                                                        bw.close();
                                                    }
                                                    catch (Throwable throwable3) {
                                                        throwable.addSuppressed(throwable3);
                                                    }
                                                } else {
                                                    bw.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (this.config.entriesDump) {
                            File entriesDumpFile = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "dump" + Reference.SLASH + "entriesDump.txt");
                            try {
                                if (!entriesDumpFile.createNewFile()) break block55;
                                try {
                                    bw = new BufferedWriter(new FileWriter(entriesDumpFile));
                                    throwable = null;
                                    try {
                                        this.apiResourceMap.values().forEach(resource -> {
                                            try {
                                                bw.write(resource.name);
                                                bw.newLine();
                                                resource.getChildrenCollection().forEach(children -> {
                                                    try {
                                                        bw.write("\t" + children.name);
                                                        bw.newLine();
                                                    }
                                                    catch (IOException e) {
                                                        e.printStackTrace();
                                                    }
                                                });
                                                bw.newLine();
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        });
                                    }
                                    catch (Throwable throwable4) {
                                        throwable = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (bw != null) {
                                            if (throwable != null) {
                                                try {
                                                    bw.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable.addSuppressed(throwable5);
                                                }
                                            } else {
                                                bw.close();
                                            }
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.config.unifiedEntriesDump) {
                        File unifiedEntriesDumpFile = new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "dump" + Reference.SLASH + "unifiedEntriesDump.txt");
                        try {
                            if (!unifiedEntriesDumpFile.createNewFile()) break block56;
                            try {
                                bw = new BufferedWriter(new FileWriter(unifiedEntriesDumpFile));
                                throwable = null;
                                try {
                                    this.resourceMap.values().forEach(resource -> {
                                        try {
                                            bw.write(resource.name);
                                            bw.newLine();
                                            resource.getChildrenCollection().forEach(children -> {
                                                if (children.isSorted()) {
                                                    try {
                                                        bw.write("\t" + children.name);
                                                        bw.newLine();
                                                    }
                                                    catch (IOException e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                            });
                                            bw.newLine();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    });
                                }
                                catch (Throwable throwable6) {
                                    throwable = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (bw != null) {
                                        if (throwable != null) {
                                            try {
                                                bw.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            bw.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

