/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;

public class TextBlockClient {
    public List<ITextComponent> lines = new ArrayList<ITextComponent>();
    private Style style = new Style();
    public int color = 0xE0E0E0;
    public String name;

    public TextBlockClient(String name, String text, int lineWidth) {
        this(text, lineWidth, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.name = name;
    }

    public TextBlockClient(String name, String text, int lineWidth, int color) {
        this(name, text, lineWidth);
        this.color = color;
    }

    public TextBlockClient(String text, int lineWidth) {
        this(text, lineWidth, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public TextBlockClient(String text, int lineWidth, EntityPlayer player) {
        String line = "";
        text = text.replaceAll("\n", " \n ");
        text = text.replaceAll("\r", " \r ");
        String[] words = text.split(" ");
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (String word : words) {
            char c;
            if (word.isEmpty()) continue;
            if (word.length() == 1 && ((c = word.charAt(0)) == '\r' || c == '\n')) {
                this.addLine(line);
                line = "";
                continue;
            }
            String newLine = line.isEmpty() ? word : line + " " + word;
            if (font.func_78256_a(newLine) > lineWidth) {
                this.addLine(line);
                line = word.trim();
                continue;
            }
            line = newLine;
        }
        if (!line.isEmpty()) {
            this.addLine(line);
        }
    }

    private void addLine(String text) {
        TextComponentString line = new TextComponentString(text);
        line.func_150255_a(this.style);
        this.lines.add((ITextComponent)line);
    }
}

