/*
 * Decompiled with CFR 0.152.
 */
package com.camellias.resizer.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ClimbingHandler {
    public static boolean movingForward(EntityLivingBase player, EnumFacing facing) {
        return (double)facing.func_176730_m().func_177958_n() * player.field_70159_w > 0.0 || (double)facing.func_176730_m().func_177952_p() * player.field_70179_y > 0.0;
    }

    public static boolean isHeadspaceFree(World world, BlockPos pos, int height) {
        for (int y = 0; y < height; ++y) {
            if (ClimbingHandler.isOpenBlockSpace(world, pos.func_177982_a(0, y, 0))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOpenBlockSpace(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return !iblockstate.func_177230_c().isNormalCube(iblockstate, (IBlockAccess)world, pos);
    }

    public static boolean canClimb(EntityPlayer player, EnumFacing facing) {
        World world = player.func_130014_f_();
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        IBlockState f = world.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
        IBlockState t = world.func_180495_p(pos.func_177982_a(0, 1, 0).func_177972_a(facing));
        IBlockState h = world.func_180495_p(pos.func_177982_a(0, 1, 0));
        IBlockState b = world.func_180495_p(pos.func_177982_a(0, 0, 0));
        Block fb = f.func_177230_c();
        Block tb = t.func_177230_c();
        Block hb = h.func_177230_c();
        Block bb = b.func_177230_c();
        boolean fbpass = fb.func_176205_b((IBlockAccess)world, pos.func_177972_a(facing));
        boolean tbpass = tb.func_176205_b((IBlockAccess)world, pos.func_177982_a(0, 1, 0).func_177972_a(facing));
        boolean hbpass = hb.func_176205_b((IBlockAccess)world, pos.func_177982_a(0, 1, 0));
        boolean bbpass = bb.func_176205_b((IBlockAccess)world, pos);
        if (bbpass && !fbpass) {
            if (!tbpass && !hbpass) {
                if (tb instanceof BlockPane) {
                    // empty if block
                }
                if (hb instanceof BlockStairs && h.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing.func_176734_d()) {
                    return true;
                }
                return hb instanceof BlockSlab && !h.func_185915_l() && h.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
            }
            return true;
        }
        if (bb instanceof BlockPane && !(hb instanceof BlockPane)) {
            return true;
        }
        if (bb instanceof BlockStairs && b.func_177229_b((IProperty)BlockStairs.field_176309_a) == facing && b.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.TOP) {
            return true;
        }
        return bb instanceof BlockSlab && !h.func_185915_l() && b.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM;
    }
}

