/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.itemhandler.IItemHandlerCompat;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GrocketTransferFilter
extends Grocket
implements IDynamicHandler {
    public SingleStackHandlerFilter.EitherFilter filter = this.registerNBT("filter", new SingleStackHandlerFilter.EitherFilter());
    public NBTSerializable.NBTEnum<Limit> limit = this.registerNBT("limit", new NBTSerializable.NBTEnum<Limit>(Limit.UNLIMITED));
    public NBTSerializable.NBTEnum<Order> order = this.registerNBT("order", new NBTSerializable.NBTEnum<Order>(Order.Normal));

    @Override
    public List<ItemStack> getDrops() {
        if (StackHelper.isNonNull(this.filter.getStack())) {
            ArrayList drops = Lists.newArrayList(super.getDrops());
            drops.add(this.filter.getStack());
            return drops;
        }
        return super.getDrops();
    }

    @Override
    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        IFluidHandler handler;
        if (capability == CapGetter.FluidHandler && (handler = CapGetter.FluidHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return handler.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null || !GrocketTransferFilter.this.filter.matches(resource)) {
                        return 0;
                    }
                    return handler.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null || !GrocketTransferFilter.this.filter.matches(resource)) {
                        return null;
                    }
                    return handler.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (maxDrain == 0) {
                        return null;
                    }
                    FluidStack drain = handler.drain(maxDrain, false);
                    if (drain == null || !GrocketTransferFilter.this.filter.matches(drain)) {
                        return null;
                    }
                    if (doDrain) {
                        return handler.drain(maxDrain, true);
                    }
                    return drain;
                }
            };
        }
        if (capability == CapGetter.ItemHandler && (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IItemHandlerCompat((IItemHandler)handler){
                final /* synthetic */ IItemHandler val$handler;
                {
                    this.val$handler = iItemHandler;
                }

                @Override
                public int getSlots() {
                    return this.val$handler.getSlots();
                }

                @Override
                @ItemStackNonNull
                public ItemStack getStackInSlot(int slot) {
                    return this.val$handler.getStackInSlot(slot);
                }

                @Override
                @ItemStackNonNull
                public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
                    ItemStack test;
                    if (StackHelper.isNull(stack)) {
                        return StackHelper.empty();
                    }
                    if (!GrocketTransferFilter.this.filter.matches(stack)) {
                        return stack;
                    }
                    Limit limit = (Limit)((Object)GrocketTransferFilter.this.limit.value);
                    if (limit == Limit.UNLIMITED) {
                        return this.val$handler.insertItem(slot, stack, simulate);
                    }
                    if (limit == Limit.SINGLE ? StackHelper.isNonNull(this.val$handler.getStackInSlot(slot)) : (test = this.val$handler.insertItem(slot, stack, true)) == stack || StackHelper.isNonNull(test) && StackHelper.getStacksize(test) == StackHelper.getStacksize(stack)) {
                        return stack;
                    }
                    for (int i = 0; i < this.val$handler.getSlots(); ++i) {
                        ItemStack stackInSlot;
                        if (i == slot || !StackHelper.isNonNull(stackInSlot = this.val$handler.getStackInSlot(i)) || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) continue;
                        return stack;
                    }
                    if (limit == Limit.SINGLE && StackHelper.getStacksize(stack) > 1) {
                        ItemStack singleVariant = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                        boolean success = StackHelper.isNull(this.val$handler.insertItem(slot, singleVariant, simulate));
                        if (success) {
                            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(StackHelper.getStacksize(stack) - 1));
                        }
                        return stack;
                    }
                    return this.val$handler.insertItem(slot, stack, simulate);
                }

                @Override
                @ItemStackNonNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (amount == 0) {
                        return StackHelper.empty();
                    }
                    ItemStack itemStack = this.val$handler.extractItem(slot, amount, true);
                    if (StackHelper.isNull(itemStack)) {
                        return StackHelper.empty();
                    }
                    if (!GrocketTransferFilter.this.filter.matches(itemStack)) {
                        return StackHelper.empty();
                    }
                    if (simulate) {
                        return itemStack;
                    }
                    return this.val$handler.extractItem(slot, amount, false);
                }
            };
        }
        return super.getInterface(tileEntity, capability);
    }

    @Override
    public GrocketType getType() {
        return GrocketType.FILTER_ITEMS;
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.holder.func_145831_w().field_72995_K) {
            this.holder.openGui(playerIn, this);
        }
        return true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferNodeContainer(player);
    }

    public class TransferNodeContainer
    extends DynamicContainerTile {
        public TransferNodeContainer(EntityPlayer player) {
            super(GrocketTransferFilter.this.holder);
            this.addTitle("Transfer Filter");
            this.crop();
            this.addWidget(GrocketTransferFilter.this.filter.newSlot(4, this.height + 4));
            this.addWidget((IWidget)((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<Limit>(26, this.height + 4){

                @Override
                protected void onSelectedServer(Limit marker) {
                    GrocketTransferFilter.this.limit.value = marker;
                    GrocketTransferFilter.this.markDirty();
                }

                @Override
                public Limit getSelectedValue() {
                    return (Limit)((Object)GrocketTransferFilter.this.limit.value);
                }
            }.addChoice(Limit.UNLIMITED, "Unlimited", null)).addChoice((Limit)Limit.SINGLE, "Single Item", null)).addChoice((Limit)Limit.SINGLESTACK, "Single Stack", null));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    static enum Limit {
        UNLIMITED,
        SINGLE,
        SINGLESTACK;

    }

    static enum Order {
        Normal,
        Reverse;

    }
}

