/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;

public class AbilityHelpers {
    public static final int[] RARITY_COLORS = new int[]{Helpers.RGBToInt((int)255, (int)255, (int)255), Helpers.RGBToInt((int)255, (int)255, (int)0), Helpers.RGBToInt((int)0, (int)255, (int)255), Helpers.RGBToInt((int)255, (int)0, (int)255)};

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level < 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level < 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelForExperience(int experience) {
        int newXp;
        int i = 0;
        int lastXp = -1;
        while ((newXp = AbilityHelpers.getExperienceForLevel(i)) <= experience && newXp > lastXp) {
            ++i;
            lastXp = newXp;
        }
        return i - 1;
    }

    public static void onPlayerAbilityChanged(EntityPlayer player, IAbilityType abilityType, int oldLevel, int newLevel) {
        abilityType.onChangedLevel(player, oldLevel, newLevel);
    }

    @Nullable
    public static Ability addPlayerAbility(EntityPlayer player, Ability ability, boolean doAdd, boolean modifyXp) {
        int oldLevel;
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        int n = oldLevel = abilityStore.hasAbilityType(ability.getAbilityType()) ? abilityStore.getAbility(ability.getAbilityType()).getLevel() : 0;
        if (GeneralConfig.maxPlayerAbilities >= 0 && oldLevel == 0 && GeneralConfig.maxPlayerAbilities <= abilityStore.getAbilities().size()) {
            return null;
        }
        Ability result = abilityStore.addAbility(ability, doAdd);
        int currentXp = player.field_71067_cb;
        if (result != null && modifyXp && AbilityHelpers.getExperience(result) > currentXp) {
            int maxLevels = player.field_71067_cb / result.getAbilityType().getBaseXpPerLevel();
            result = maxLevels == 0 ? null : new Ability(result.getAbilityType(), maxLevels);
        }
        if (doAdd && result != null) {
            player.field_71067_cb -= AbilityHelpers.getExperience(result);
            player.field_71068_ca = AbilityHelpers.getLevelForExperience(player.field_71067_cb);
            int xpForLevel = AbilityHelpers.getExperienceForLevel(player.field_71068_ca);
            player.field_71106_cc = (float)(player.field_71067_cb - xpForLevel) / (float)player.func_71050_bK();
            int newLevel = abilityStore.getAbility(result.getAbilityType()).getLevel();
            AbilityHelpers.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
        }
        return result;
    }

    @Nullable
    public static Ability removePlayerAbility(EntityPlayer player, Ability ability, boolean doRemove, boolean modifyXp) {
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        int oldLevel = abilityStore.hasAbilityType(ability.getAbilityType()) ? abilityStore.getAbility(ability.getAbilityType()).getLevel() : 0;
        Ability result = abilityStore.removeAbility(ability, doRemove);
        if (modifyXp && result != null) {
            player.func_71023_q(AbilityHelpers.getExperience(result));
            int newLevel = abilityStore.hasAbilityType(result.getAbilityType()) ? abilityStore.getAbility(result.getAbilityType()).getLevel() : 0;
            AbilityHelpers.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
        }
        return result;
    }

    public static int getExperience(Ability ability) {
        if (ability == null) {
            return 0;
        }
        return ability.getAbilityType().getBaseXpPerLevel() * ability.getLevel();
    }

    public static void setPlayerAbilities(EntityPlayerMP player, Map<IAbilityType, Integer> abilityTypes) {
        IMutableAbilityStore abilityStore = (IMutableAbilityStore)player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        abilityStore.setAbilities(abilityTypes);
    }

    public static boolean canInsert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.addAbility(ability, false);
        return added != null && added.getLevel() == ability.getLevel();
    }

    public static boolean canExtract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.removeAbility(ability, false);
        return added != null && added.getLevel() == ability.getLevel();
    }

    public static boolean canInsertToPlayer(Ability ability, EntityPlayer player) {
        Ability added = AbilityHelpers.addPlayerAbility(player, ability, false, true);
        return added != null && added.getLevel() == ability.getLevel();
    }

    public static Ability insert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.addAbility(ability, true);
    }

    public static Ability extract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.removeAbility(ability, true);
    }

    public static Optional<IAbilityType> getRandomAbility(Random random, EnumRarity rarity) {
        List<IAbilityType> abilities = AbilityTypes.REGISTRY.getAbilityTypes(rarity);
        if (abilities.size() > 0) {
            return Optional.of(abilities.get(random.nextInt(abilities.size())));
        }
        return Optional.empty();
    }

    public static Optional<IAbilityType> getRandomAbilityUntil(Random random, EnumRarity rarity, boolean inclusive) {
        NavigableSet<EnumRarity> validRarities = AbilityHelpers.getValidAbilityRarities().headSet(rarity, inclusive);
        Iterator<EnumRarity> it = validRarities.descendingIterator();
        while (it.hasNext()) {
            Optional<IAbilityType> optional = AbilityHelpers.getRandomAbility(random, it.next());
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getRandomTotem(EnumRarity rarity, Random rand) {
        return AbilityHelpers.getRandomAbility(rand, rarity).flatMap(abilityType -> Optional.of(ItemAbilityTotem.getInstance().getTotem(new Ability((IAbilityType)abilityType, 1))));
    }

    public static EnumRarity getRandomRarity(Random rand) {
        int chance = rand.nextInt(50);
        EnumRarity rarity = chance >= 49 ? EnumRarity.EPIC : (chance >= 40 ? EnumRarity.RARE : (chance >= 25 ? EnumRarity.UNCOMMON : EnumRarity.COMMON));
        if (!AbilityHelpers.hasRarityAbilities(rarity)) {
            int size = AbilityTypes.REGISTRY.getAbilityTypes().size();
            if (size == 0) {
                throw new IllegalStateException("No abilities were registered, at least one ability must be enabled for this mod to function correctly.");
            }
            rarity = ((IAbilityType)Iterables.get(AbilityTypes.REGISTRY.getAbilityTypes(), (int)rand.nextInt(size))).getRarity();
        }
        return rarity;
    }

    public static boolean hasRarityAbilities(EnumRarity rarity) {
        return !AbilityTypes.REGISTRY.getAbilityTypes(rarity).isEmpty();
    }

    public static NavigableSet<EnumRarity> getValidAbilityRarities() {
        TreeSet rarities = Sets.newTreeSet();
        for (EnumRarity rarity : EnumRarity.values()) {
            if (AbilityTypes.REGISTRY.getAbilityTypes(rarity).isEmpty()) continue;
            rarities.add(rarity);
        }
        return rarities;
    }

    public static Triple<Integer, Integer, Integer> getAverageRarityColor(IAbilityStore abilityStore) {
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 1;
        for (IAbilityType abilityType : abilityStore.getAbilityTypes()) {
            Triple color = Helpers.intToRGB((int)RARITY_COLORS[Math.min(RARITY_COLORS.length - 1, abilityType.getRarity().ordinal())]);
            r = (int)((float)r + ((Float)color.getLeft()).floatValue() * 255.0f);
            g = (int)((float)g + ((Float)color.getMiddle()).floatValue() * 255.0f);
            b = (int)((float)b + ((Float)color.getRight()).floatValue() * 255.0f);
            ++count;
        }
        return Triple.of((Object)(r / count), (Object)(g / count), (Object)(b / count));
    }

    public static EnumRarity getSafeRarity(int rarity) {
        return rarity < 0 ? EnumRarity.COMMON : (rarity >= EnumRarity.values().length ? EnumRarity.EPIC : EnumRarity.values()[rarity]);
    }
}

