/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypePotionEffectRadius
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 10;
    private final Potion potion;
    private boolean hostile;
    private static String[] friendlyMobs = null;

    public AbilityTypePotionEffectRadius(String id, int rarity, int maxLevel, int baseXpPerLevel, Potion potion, boolean isHostile) {
        super(id, rarity, maxLevel, baseXpPerLevel);
        this.potion = potion;
        this.hostile = isHostile;
        if (this.potion == null) {
            EverlastingAbilities.clog(Level.WARN, "Tried to register a null potion for ability " + id + ". This is possibly caused by a mod forcefully removing the potion effect for this ability.");
        }
    }

    public AbilityTypePotionEffectRadius(String id, int rarity, int maxLevel, int baseXpPerLevel, Potion potion) {
        this(id, rarity, maxLevel, baseXpPerLevel, potion, true);
    }

    protected int getDuration(int tickModulus, int level) {
        return tickModulus * 6;
    }

    protected int getTickModulus(int level) {
        return 10;
    }

    protected int getAmplifier(int level) {
        return level - 1;
    }

    @Override
    public void onTick(EntityPlayer player, int level) {
        World world = player.field_70170_p;
        if (this.potion != null && !world.field_72995_K && player.field_70170_p.func_82737_E() % (long)this.getTickModulus(level) == 0L) {
            int radius = level * 2;
            List mobs = world.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius), EntitySelectors.field_180132_d);
            for (EntityLivingBase mob : mobs) {
                if (this.hostile && AbilityTypePotionEffectRadius.isFriendlyMob(mob, player)) continue;
                mob.func_70690_d(new PotionEffect(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isFriendlyMob(EntityLivingBase mob, EntityPlayer player) {
        ResourceLocation resourceLocation = mob instanceof EntityPlayer ? new ResourceLocation("player") : EntityList.func_191301_a((Entity)mob);
        String mobName = resourceLocation == null ? "null" : resourceLocation.toString();
        if (mob == player) return true;
        if (player.func_184191_r((Entity)mob)) return true;
        if (mob instanceof IEntityOwnable) {
            if (((IEntityOwnable)mob).func_70902_q() == player) return true;
        }
        if (!Arrays.stream(friendlyMobs).anyMatch(mobName::matches)) return false;
        return true;
    }

    public static void loadBlacklist(String[] mobNames) {
        friendlyMobs = mobNames;
    }
}

