/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.apache.logging.log4j.Level;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.ability.AbilityTypeDefault;

public class AbilityTypePotionEffectSelf
extends AbilityTypeDefault {
    private static final int TICK_MODULUS = 10;
    private final Potion potion;

    public AbilityTypePotionEffectSelf(String id, int rarity, int maxLevel, int baseXpPerLevel, Potion potion) {
        super(id, rarity, maxLevel, baseXpPerLevel);
        this.potion = potion;
        if (this.potion == null) {
            EverlastingAbilities.clog(Level.WARN, "Tried to register a null potion for ability " + id + ". This is possibly caused by a mod forcefully removing the potion effect for this ability.");
        }
    }

    protected int getDuration(int tickModulus, int level) {
        return tickModulus * 5;
    }

    protected int getTickModulus(int level) {
        return 10;
    }

    protected int getAmplifier(int level) {
        return level - 1;
    }

    @Override
    public void onTick(EntityPlayer player, int level) {
        if (this.potion != null && player.field_70170_p.func_82737_E() % (long)this.getTickModulus(level) == 0L) {
            player.func_70690_d(new PotionEffect(this.potion, this.getDuration(this.getTickModulus(level), level), this.getAmplifier(level), true, GeneralConfig.showPotionEffectParticles));
        }
    }
}

