/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;

public class DefaultAbilityStore
implements IAbilityStore {
    protected final Map<IAbilityType, Integer> abilityTypes = Maps.newLinkedHashMap();

    public DefaultAbilityStore() {
    }

    public DefaultAbilityStore(DefaultMutableAbilityStore abilityStore) {
        this.setAbilities(abilityStore.abilityTypes);
    }

    @Override
    public void setAbilities(Map<IAbilityType, Integer> abilityTypes) {
        this.abilityTypes.clear();
        this.abilityTypes.putAll(abilityTypes);
    }

    @Override
    public boolean hasAbilityType(IAbilityType abilityType) {
        return this.abilityTypes.containsKey(abilityType);
    }

    @Override
    public Collection<IAbilityType> getAbilityTypes() {
        return this.abilityTypes.keySet();
    }

    @Override
    public Collection<Ability> getAbilities() {
        ArrayList abilities = Lists.newArrayList();
        for (IAbilityType abilityType : this.getAbilityTypes()) {
            abilities.add(this.getAbility(abilityType));
        }
        return abilities;
    }

    @Override
    public Map<IAbilityType, Integer> getAbilitiesRaw() {
        return Collections.unmodifiableMap(this.abilityTypes);
    }

    @Override
    public Ability getAbility(IAbilityType abilityType) {
        if (!this.hasAbilityType(abilityType)) {
            return null;
        }
        return new Ability(abilityType, this.abilityTypes.get(abilityType));
    }
}

