/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.block.IEnumBlock;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.itemblock.ItemBlockEnum;
import shadows.placebo.util.PlaceboUtil;
import shadows.plants2.block.BushBase;
import shadows.plants2.data.PlantConstants;
import shadows.plants2.util.PlantUtil;

public abstract class BlockEnumBush<E extends Enum<E>>
extends BushBase
implements IEnumBlock<E> {
    protected final List<E> types = new ArrayList();
    protected final Predicate<E> valueFilter;
    protected final PropertyEnum<E> property;
    protected final BlockStateContainer realStateContainer;
    protected final E value;

    public BlockEnumBush(String name, EnumPlantType type, Class<E> enumClass, int predicate) {
        super(name, type);
        this.valueFilter = e -> ((IPropertyEnum)e).getPredicateIndex() == predicate;
        this.property = PropertyEnum.func_177708_a((String)"type", enumClass, this.valueFilter);
        this.types.addAll(this.property.func_177700_c());
        if (this.types.size() > this.getMaxEnumValues()) {
            throw new IllegalArgumentException("Trying to create a " + ((Object)((Object)this)).getClass().getSimpleName() + " with " + this.types.size() + " enum constants is invalid");
        }
        this.realStateContainer = this.createStateContainer();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.getInvProperty(), (Comparable)Boolean.valueOf(false)));
        for (Enum e2 : this.types) {
            ((IPropertyEnum)e2).set((IForgeRegistryEntry)this);
        }
        this.value = null;
    }

    public BlockEnumBush(String name, EnumPlantType type, E enumValue) {
        super(name, type);
        this.valueFilter = null;
        this.property = null;
        this.types.add(enumValue);
        this.realStateContainer = this.createStateContainer();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.getInvProperty(), (Comparable)Boolean.valueOf(false)));
        ((IPropertyEnum)enumValue).set((IForgeRegistryEntry)this);
        this.value = enumValue;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.property == null) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(this.property, (Comparable)this.types.get(meta));
    }

    public IBlockState getStateFor(E e) {
        if (this.property == null) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(this.property, e);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockEnum((IEnumBlock)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels(ModelRegistryEvent e) {
        if (this.property == null) {
            PlaceboUtil.sMRL((String)"plants", (Block)this, (int)0, (String)("inventory=true,type=" + ((IPropertyEnum)this.value).func_176610_l()));
        } else {
            for (int i = 0; i < this.types.size(); ++i) {
                PlaceboUtil.sMRL((String)"plants", (Block)this, (int)i, (String)("inventory=true," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l()));
            }
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "plants", this.property == null ? ",type=" + ((IPropertyEnum)this.value).func_176610_l() : "");
    }

    public IBlockState func_176203_a(int meta) {
        if (this.property == null) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(this.property, (Comparable)this.types.get(meta));
    }

    public int func_176201_c(IBlockState state) {
        if (this.property == null) {
            return 0;
        }
        return ((Enum)((Object)state.func_177229_b(this.property))).ordinal() % 16;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.types.size(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected final BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).build();
    }

    public final BlockStateContainer func_176194_O() {
        return this.realStateContainer;
    }

    public List<E> getTypes() {
        return this.types;
    }

    public PropertyBool getInvProperty() {
        return PlantConstants.INV;
    }

    public BlockStateContainer createStateContainer() {
        if (this.property == null) {
            return new BlockStateContainer((Block)this, new IProperty[]{this.getInvProperty()});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, this.getInvProperty()});
    }

    public BlockStateContainer getRealStateContainer() {
        return this.realStateContainer;
    }

    @Nullable
    public PropertyEnum<E> getProperty() {
        return this.property;
    }

    public String func_149739_a() {
        return "tile.plants2";
    }

    @Override
    protected void addStatesToList() {
        List<IBlockState> list = PlantUtil.TYPE_TO_STATES.get(this.type);
        for (Enum e : this.types) {
            list.add(this.getStateFor(e));
        }
    }

    protected int getMaxEnumValues() {
        return 16;
    }
}

