/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.gen.forgotten;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import shadows.plants2.block.BlockEnumDoubleFlower;
import shadows.plants2.block.BlockEnumDoubleHarvestBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.enums.TheBigBookOfEnums;
import shadows.plants2.init.ModRegistry;

public class BushGen
implements IWorldGenerator {
    private static final IBlockState LOG = Loader.isModLoaded((String)"extratrees") ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("extratrees:shrub_log"))).func_176223_P() : Blocks.field_150364_r.func_176223_P();
    public static final Bush BLACKBERRY_BUSH = new Bush(LOG, ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.BLACKBERRY), false);
    public static final Bush BLUEBERRY_BUSH = new Bush(LOG, ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.BLUEBERRY), false);
    public static final Bush DECIDUOUS_BUSH = new Bush(LOG, ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.DECIDUOUS), false);
    public static final Bush EVERGREEN_BUSH = new Bush(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.EVERGREEN), false);
    public static final Bush HUCKLEBERRY_BUSH = new Bush(LOG, ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.HUCKLEBERRY), false);
    public static final Bush RASPBERRY_BUSH = new Bush(LOG, ModRegistry.BUSH.getStateFor((Enum)TheBigBookOfEnums.BushSet.RASPBERRY), false);
    public static final Bush[] BUSHGENS = new Bush[]{BLACKBERRY_BUSH, BLUEBERRY_BUSH, DECIDUOUS_BUSH, EVERGREEN_BUSH, HUCKLEBERRY_BUSH, RASPBERRY_BUSH};

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator gen, IChunkProvider prov) {
        int posZ;
        if (rand.nextInt(20) != 0) {
            return;
        }
        if (PlantConfig.DIM_BL.contains((Object)world.field_73011_w.getDimension())) {
            return;
        }
        int posX = chunkX * 16 + MathHelper.func_76136_a((Random)rand, (int)4, (int)12);
        BlockPos genPos = new BlockPos(posX, 0, posZ = chunkZ * 16 + MathHelper.func_76136_a((Random)rand, (int)4, (int)12));
        if (PlantConfig.COMPUTED_BIOME_BL.contains((Object)world.func_180494_b(genPos))) {
            return;
        }
        genPos = world.func_175672_r(genPos);
        IBlockState soil = world.func_180495_p(genPos.func_177977_b());
        IBlockState state = world.func_180495_p(genPos);
        if (state.func_177230_c().func_176200_f((IBlockAccess)world, genPos) && state.func_185904_a() != Material.field_151586_h && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, genPos.func_177977_b(), EnumFacing.DOWN, (IPlantable)Blocks.field_150329_H)) {
            BUSHGENS[rand.nextInt(6)].func_180709_b(world, rand, genPos);
        }
    }

    public static class Bush
    extends WorldGenAbstractTree {
        private final IBlockState log;
        private final IBlockState leaf;

        public Bush(IBlockState log, IBlockState leaf, boolean notify) {
            super(notify);
            this.log = log;
            this.leaf = leaf;
        }

        public boolean func_180709_b(World world, Random rand, BlockPos pos) {
            this.func_175903_a(world, pos, this.log);
            for (int i = 0; i < 4; ++i) {
                EnumFacing face = EnumFacing.field_176754_o[i];
                EnumFacing face2 = EnumFacing.field_176754_o[i + 1 == 4 ? 0 : i + 1];
                for (int k = -1; k < 2; ++k) {
                    this.checkAndLeaf(world, pos.func_177972_a(face).func_177967_a(face2, k));
                    if (k != 0) continue;
                    this.checkAndLeaf(world, pos.func_177967_a(face, 2));
                }
                this.checkAndLeaf(world, pos.func_177972_a(face).func_177984_a());
            }
            this.checkAndLeaf(world, pos.func_177984_a());
            return true;
        }

        private void checkAndLeaf(World world, BlockPos pos) {
            if (this.isReplaceable(world, pos) && world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID) {
                this.func_175903_a(world, pos, this.leaf);
            }
        }

        public boolean isReplaceable(World world, BlockPos pos) {
            boolean flag;
            Block block = world.func_180495_p(pos).func_177230_c();
            boolean bl = flag = block.func_176200_f((IBlockAccess)world, pos) || block instanceof BlockBush;
            if (flag && (block instanceof BlockDoublePlant || block instanceof BlockEnumDoubleFlower || block instanceof BlockEnumDoubleHarvestBush)) {
                world.func_175698_g(pos.func_177984_a());
            }
            return flag;
        }
    }
}

