/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.event;

import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.CreativeConfigRegistry;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigurationClientPacket;
import com.creativemd.creativecore.common.config.sync.ConfigurationPacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

public class ConfigEventHandler {
    private final DecimalFormat df = this.generateFormat();
    private final File CONFIG_DIRECTORY;
    private final Logger LOGGER;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private DecimalFormat generateFormat() {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
        return df;
    }

    public ConfigEventHandler(File CONFIG_DIRECTORY, Logger LOGGER) {
        this.CONFIG_DIRECTORY = CONFIG_DIRECTORY;
        this.LOGGER = LOGGER;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.func_184102_h().func_71264_H() || !this.isOwner(event.player.func_184102_h())) {
            PacketHandler.sendPacketToPlayer(new ConfigurationClientPacket(CreativeConfigRegistry.ROOT), (EntityPlayerMP)event.player);
            this.syncAll((EntityPlayerMP)event.player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isOwner(MinecraftServer server) {
        return server.func_71214_G().equals(Minecraft.func_71410_x().func_110432_I().func_111285_a());
    }

    @SubscribeEvent
    public void loadWorld(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            this.load(Side.CLIENT);
        }
    }

    public void serverStarting() {
        this.load(Side.SERVER);
    }

    public void sync(ICreativeConfigHolder holder) {
        PacketHandler.sendPacketToAllPlayers(new ConfigurationPacket(holder));
    }

    public void sync(ICreativeConfigHolder holder, EntityPlayerMP player) {
        PacketHandler.sendPacketToPlayer(new ConfigurationPacket(holder), player);
    }

    public void syncAll() {
        this.sync(CreativeConfigRegistry.ROOT);
    }

    public void syncAll(EntityPlayerMP player) {
        this.sync(CreativeConfigRegistry.ROOT, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClientFields() {
        File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
        List<String> enabled = ConfigEventHandler.loadClientFieldList(CreativeConfigRegistry.ROOT);
        if (enabled.isEmpty()) {
            config.delete();
            return;
        }
        JsonArray array = new JsonArray();
        for (int i = 0; i < enabled.size(); ++i) {
            array.add(enabled.get(i));
        }
        try (FileWriter writer = new FileWriter(config);){
            this.GSON.toJson((JsonElement)array, (Appendable)writer);
        }
        catch (IOException e) {
            this.LOGGER.error("Failed to save client field config file {0}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String modid, Side side) {
        block7: {
            try {
                Object object = CreativeConfigRegistry.ROOT.get(modid);
                File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
                if (object instanceof ICreativeConfigHolder || object == null) {
                    ICreativeConfigHolder holder = (ICreativeConfigHolder)object;
                    JsonObject json = holder.save(true, side);
                    JsonUtils.cleanUp(json);
                    if (json.size() <= 0) break block7;
                    FileWriter writer = new FileWriter(config);
                    JsonWriter jsonWriter = new JsonWriter(writer){

                        public JsonWriter value(double value) throws IOException {
                            if (Double.isNaN(value) || Double.isInfinite(value)) {
                                throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
                            }
                            return this.jsonValue(ConfigEventHandler.this.df.format(value));
                        }

                        public JsonWriter value(Number value) throws IOException {
                            if (value instanceof Double || value.getClass() == Double.TYPE) {
                                return this.value((Double)value);
                            }
                            return super.value(value);
                        }
                    };
                    jsonWriter.setIndent("  ");
                    try {
                        this.GSON.toJson((JsonElement)json, jsonWriter);
                        break block7;
                    }
                    finally {
                        writer.close();
                    }
                }
                if (config.exists()) {
                    config.delete();
                }
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to save config file of '{0}', {1}", (Object)modid, (Object)e);
            }
        }
    }

    public void save(Side side) {
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.save(modid, side);
        }
    }

    public void loadClientFields() {
        ArrayList<String> list;
        block6: {
            File config = new File(this.CONFIG_DIRECTORY, "client-fields.json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config);
                    JsonArray array = (JsonArray)this.GSON.fromJson((Reader)reader, JsonArray.class);
                    if (array != null) {
                        list = new ArrayList<String>(array.size());
                        for (int i = 0; i < array.size(); ++i) {
                            JsonElement element = array.get(i);
                            if (!element.isJsonPrimitive() || !((JsonPrimitive)element).isString()) continue;
                            list.add(element.getAsString());
                        }
                        break block6;
                    }
                    list = Collections.EMPTY_LIST;
                }
                catch (FileNotFoundException e) {
                    list = Collections.EMPTY_LIST;
                    this.LOGGER.error("Failed to load client fields config file, {0}", (Throwable)e);
                }
            } else {
                list = Collections.EMPTY_LIST;
            }
        }
        ConfigEventHandler.saveClientFieldList(CreativeConfigRegistry.ROOT, (List<String>)list);
    }

    public void load(String modid, Side side) {
        Object object = CreativeConfigRegistry.ROOT.get(modid);
        if (object instanceof ICreativeConfigHolder) {
            ICreativeConfigHolder holder = (ICreativeConfigHolder)object;
            File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
            if (config.exists()) {
                try {
                    FileReader reader = new FileReader(config);
                    JsonObject json = (JsonObject)this.GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json == null) {
                        json = new JsonObject();
                    }
                    holder.load(true, json, side);
                }
                catch (FileNotFoundException e) {
                    this.LOGGER.error("Failed to load config file of '{0}', {1}", (Object)modid, (Object)e);
                }
            } else {
                holder.restoreDefault(side);
            }
        }
    }

    public void load(Side side) {
        this.loadClientFields();
        for (String modid : CreativeConfigRegistry.ROOT.names()) {
            this.load(modid, side);
        }
        this.save(side);
    }

    public static List<String> loadClientFieldList(ICreativeConfigHolder holder) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.loadClientFieldList(holder, configKey, enabled);
        }
        return enabled;
    }

    private static List<String> loadClientFieldList(ICreativeConfigHolder parent, ConfigKey field, List<String> list) {
        if (field.forceSynchronization) {
            list.add((parent.path().length > 0 ? String.join((CharSequence)".", parent.path()) + "." : "") + field.name);
            return list;
        }
        if (field.get() instanceof ICreativeConfigHolder) {
            ICreativeConfigHolder holder = (ICreativeConfigHolder)field.get();
            for (ConfigKey configKey : holder.fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.loadClientFieldList(holder, configKey, list);
            }
        }
        return list;
    }

    public static void saveClientFieldList(ICreativeConfigHolder holder, List<String> enabled) {
        for (ConfigKey configKey : holder.fields()) {
            if (!configKey.isWithoutForce(Side.CLIENT)) continue;
            ConfigEventHandler.saveClientFieldList(String.join((CharSequence)".", holder.path()), configKey, enabled);
        }
    }

    private static void saveClientFieldList(String path, ConfigKey field, List<String> enabled) {
        if (!path.isEmpty()) {
            path = path + ".";
        }
        if (enabled.contains(path = path + field.name)) {
            ConfigEventHandler.enable(field);
        } else {
            field.forceSynchronization = false;
            Object object = field.get();
            if (object instanceof ICreativeConfigHolder) {
                for (ConfigKey configKey : ((ICreativeConfigHolder)object).fields()) {
                    if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                    ConfigEventHandler.saveClientFieldList(path, configKey, enabled);
                }
            }
        }
    }

    private static void enable(ConfigKey field) {
        field.forceSynchronization = true;
        Object object = field.get();
        if (object instanceof ICreativeConfigHolder) {
            for (ConfigKey configKey : ((ICreativeConfigHolder)object).fields()) {
                if (!configKey.isWithoutForce(Side.CLIENT)) continue;
                ConfigEventHandler.enable(configKey);
            }
        }
    }

    public boolean modFileExist(String modid, Side side) {
        File config = new File(this.CONFIG_DIRECTORY, modid + (side.isClient() ? "-client" : "") + ".json");
        return config.exists();
    }
}

