/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.holder;

import com.creativemd.creativecore.common.config.ConfigTypeConveration;
import com.creativemd.creativecore.common.config.holder.ConfigHolderObject;
import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraftforge.fml.relauncher.Side;

public abstract class ConfigHolder<T extends ConfigKey>
implements ICreativeConfigHolder {
    public final ConfigSynchronization synchronization;
    public final ICreativeConfigHolder parent;
    public final String[] path;
    protected PairList<String, T> fields = new PairList();

    public ConfigHolder(ICreativeConfigHolder parent, String key, ConfigSynchronization synchronization) {
        this.parent = parent;
        this.path = (String[])ObjectArrays.concat((Object[])parent.path(), (Object)key);
        this.synchronization = synchronization;
    }

    ConfigHolder() {
        this.parent = null;
        this.path = new String[0];
        this.synchronization = ConfigSynchronization.UNIVERSAL;
    }

    @Override
    public ConfigSynchronization synchronization() {
        return this.synchronization;
    }

    @Override
    public ICreativeConfigHolder parent() {
        return this.parent;
    }

    @Override
    public String[] path() {
        return this.path;
    }

    @Override
    public ConfigKey getField(String key) {
        return (ConfigKey)this.fields.getValue(key);
    }

    @Override
    public Collection<? extends ConfigKey> fields() {
        return this.fields.values();
    }

    @Override
    public Collection<String> names() {
        return this.fields.keys();
    }

    @Override
    public Object get(String key) {
        ConfigKey field = (ConfigKey)this.fields.getValue(key);
        if (field != null) {
            return field.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!(field.get() instanceof ICreativeConfigHolder ? !((ICreativeConfigHolder)field.get()).isEmpty(side) : field.is(side))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmptyWithoutForce(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!(field.get() instanceof ICreativeConfigHolder ? !((ICreativeConfigHolder)field.get()).isEmptyWithoutForce(side) : field.isWithoutForce(side))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDefault(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!((ConfigKey)((Pair)this.fields.get((int)i)).value).is(side) || ((ConfigKey)((Pair)this.fields.get((int)i)).value).isDefault(side)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreDefault(Side side) {
        this.reset(side);
    }

    protected void reset(Side side) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!((ConfigKey)((Pair)this.fields.get((int)i)).value).is(side)) continue;
            ((ConfigKey)((Pair)this.fields.get((int)i)).value).restoreDefault(side);
        }
    }

    @Override
    public void load(boolean loadDefault, JsonObject json, Side side) {
        if (loadDefault) {
            this.reset(side);
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!field.is(side) || !json.has(field.name)) continue;
            field.set(ConfigTypeConveration.read(field.getType(), field.getDefault(), loadDefault, json.get(field.name), side, field instanceof ConfigHolderObject.ConfigKeyField ? (ConfigHolderObject.ConfigKeyField)field : null));
        }
    }

    @Override
    public JsonObject save(boolean saveDefault, Side side) {
        JsonObject object = new JsonObject();
        for (int i = 0; i < this.fields.size(); ++i) {
            ConfigKey field = (ConfigKey)((Pair)this.fields.get((int)i)).value;
            if (!field.is(side) || !saveDefault && field.isDefault(side)) continue;
            object.add(field.name, ConfigTypeConveration.write(field.getType(), field.get(), field.getDefault(), saveDefault, side, field instanceof ConfigHolderObject.ConfigKeyField ? (ConfigHolderObject.ConfigKeyField)field : null));
        }
        return object;
    }
}

