/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.holder;

import com.creativemd.creativecore.common.config.ConfigTypeConveration;
import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.api.ICreativeConfig;
import com.creativemd.creativecore.common.config.holder.ConfigHolder;
import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigHolderObject
extends ConfigHolder<ConfigKeyField> {
    public final Object object;

    private static List<Field> collectFields(Class clazz, List<Field> fields) {
        if (clazz.getSuperclass() != Object.class) {
            ConfigHolderObject.collectFields(clazz.getSuperclass(), fields);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            if (!Modifier.isPublic(declaredFields[i].getModifiers())) continue;
            fields.add(declaredFields[i]);
        }
        return fields;
    }

    public ConfigHolderObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        super(parent, key, synchronization);
        this.object = object;
        List<Field> fields = ConfigHolderObject.collectFields(object.getClass(), new ArrayList<Field>());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.isAnnotationPresent(CreativeConfig.class)) continue;
            try {
                CreativeConfig config = field.getAnnotation(CreativeConfig.class);
                String name = config.name().isEmpty() ? field.getName() : config.name();
                ConfigSynchronization fieldSync = synchronization != ConfigSynchronization.UNIVERSAL ? synchronization : config.type();
                ConfigKeyField fieldKey = new ConfigKeyField(field, config.name(), ConfigTypeConveration.parseObject(this, fieldSync, name, field.get(object)), fieldSync, config.requiresRestart());
                this.fields.add(name, fieldKey);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void load(boolean loadDefault, JsonObject json, Side side) {
        super.load(loadDefault, json, side);
        if (this.object instanceof ICreativeConfig) {
            ((ICreativeConfig)this.object).configured();
        }
    }

    @Override
    protected void reset(Side side) {
        super.reset(side);
        if (this.object instanceof ICreativeConfig) {
            ((ICreativeConfig)this.object).configured();
        }
    }

    public class ConfigKeyField
    extends ConfigKey {
        public final Field field;
        public final ConfigTypeConveration converation;

        public ConfigKeyField(Field field, String configName, Object defaultValue, ConfigSynchronization synchronization, boolean requiresRestart) {
            super(field.getName(), configName, defaultValue, synchronization, requiresRestart);
            this.field = field;
            this.converation = defaultValue instanceof ICreativeConfigHolder ? null : ConfigTypeConveration.get(field.getType());
        }

        @Override
        public void set(Object object) {
            try {
                if (!(this.defaultValue instanceof ICreativeConfigHolder)) {
                    this.field.set(ConfigHolderObject.this.object, this.converation.set(this, object));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object get() {
            try {
                if (this.defaultValue instanceof ICreativeConfigHolder) {
                    return this.defaultValue;
                }
                return this.field.get(ConfigHolderObject.this.object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected boolean checkEqual(Object one, Object two) {
            if (this.converation != null) {
                return this.converation.areEqual(one, two);
            }
            return super.checkEqual(one, two);
        }

        public ConfigHolderObject getHolder() {
            return ConfigHolderObject.this;
        }
    }
}

