/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.holder;

import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.config.sync.ConfigSynchronization;
import net.minecraftforge.fml.relauncher.Side;

public abstract class ConfigKey {
    public final String name;
    public final ConfigSynchronization synchronization;
    public final boolean requiresRestart;
    protected final Object defaultValue;
    public boolean forceSynchronization;

    public ConfigKey(String fieldName, String name, Object defaultValue, ConfigSynchronization synchronization, boolean requiresRestart) {
        this.synchronization = synchronization;
        this.requiresRestart = requiresRestart;
        this.name = name.isEmpty() ? fieldName : name;
        this.defaultValue = defaultValue;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigKey) {
            return ((ConfigKey)obj).name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public abstract void set(Object var1);

    public abstract Object get();

    protected boolean checkEqual(Object one, Object two) {
        return one.equals(two);
    }

    public boolean isDefault(Side side) {
        if (this.defaultValue instanceof ICreativeConfigHolder) {
            return ((ICreativeConfigHolder)this.defaultValue).isDefault(side);
        }
        return this.checkEqual(this.defaultValue, this.get());
    }

    public boolean isDefault(Object value, Side side) {
        if (this.defaultValue instanceof ICreativeConfigHolder) {
            return ((ICreativeConfigHolder)this.defaultValue).isDefault(side);
        }
        return this.checkEqual(this.defaultValue, value);
    }

    public void restoreDefault(Side side) {
        if (this.defaultValue instanceof ICreativeConfigHolder) {
            ((ICreativeConfigHolder)this.defaultValue).restoreDefault(side);
        } else {
            this.set(this.defaultValue);
        }
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Class getType() {
        return this.defaultValue.getClass();
    }

    public boolean is(Side side) {
        if (this.defaultValue instanceof ICreativeConfigHolder) {
            return this.synchronization.useFolder(this.forceSynchronization, side);
        }
        return this.synchronization.useValue(this.forceSynchronization, side);
    }

    public boolean isWithoutForce(Side side) {
        if (this.defaultValue instanceof ICreativeConfigHolder) {
            return this.synchronization.useFolder(false, side);
        }
        return this.synchronization.useValue(false, side);
    }

    public static class ConfigKeyDynamic
    extends ConfigKey {
        private Object value;

        public ConfigKeyDynamic(String name, Object defaultValue, ConfigSynchronization type, boolean requiresRestart) {
            super(name, "", defaultValue, type, requiresRestart);
            this.value = defaultValue instanceof ICreativeConfigHolder ? null : defaultValue;
        }

        @Override
        public void set(Object object) {
            if (!(this.defaultValue instanceof ICreativeConfigHolder)) {
                this.value = object;
            }
        }

        @Override
        public Object get() {
            if (this.defaultValue instanceof ICreativeConfigHolder) {
                return this.defaultValue;
            }
            return this.value;
        }
    }
}

