/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.sync;

import com.creativemd.creativecore.common.config.gui.SubGuiClientSync;
import com.creativemd.creativecore.common.config.gui.SubGuiConfig;
import com.creativemd.creativecore.common.config.holder.CreativeConfigRegistry;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigurationPacket
extends CreativeCorePacket {
    public String[] path;
    public JsonObject json;

    public ConfigurationPacket(ICreativeConfigHolder holder) {
        this.path = holder.path();
        this.json = holder.save(false, Side.SERVER);
    }

    public ConfigurationPacket() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        ConfigurationPacket.writeString(buf, String.join((CharSequence)".", this.path));
        ConfigurationPacket.writeJson(buf, this.json);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        String text = ConfigurationPacket.readString(buf);
        this.path = text.isEmpty() ? new String[]{} : text.split(".");
        this.json = ConfigurationPacket.readJson(buf);
    }

    @Override
    public void executeClient(EntityPlayer player) {
        ICreativeConfigHolder holder = CreativeConfigRegistry.ROOT.followPath(this.path);
        if (holder != null) {
            holder.load(true, this.json, Side.SERVER);
        }
        ConfigurationPacket.updateGui(player);
    }

    @Override
    public void executeServer(EntityPlayer player) {
    }

    public static void updateGui(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerSub && (((ContainerSub)player.field_71070_bA).gui.isOpen(SubGuiConfig.class) || ((ContainerSub)player.field_71070_bA).gui.isOpen(SubGuiClientSync.class))) {
            for (SubGui layer : ((ContainerSub)player.field_71070_bA).gui.getLayers()) {
                if (layer instanceof SubGuiConfig) {
                    ((SubGuiConfig)layer).ROOT = new JsonObject();
                    ((SubGuiConfig)layer).loadHolder(((SubGuiConfig)layer).holder);
                    continue;
                }
                if (!(layer instanceof SubGuiClientSync)) continue;
                ((SubGuiClientSync)layer).tree.reload();
                ((SubGuiClientSync)layer).load(((SubGuiClientSync)layer).currentView);
            }
        }
    }
}

