/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ai.tasks;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.ai.ITaskInitializer;
import CoroUtil.ai.tasks.EntityAITargetBetter;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.forge.CULog;
import com.google.common.base.Predicate;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;

public class EntityAINearestAttackablePlayerOmniscience<T extends EntityLivingBase>
extends EntityAITargetBetter
implements ITaskInitializer,
IInvasionControlledTask {
    protected Class<EntityPlayer> targetClass;
    private int targetChance;
    protected Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;
    protected EntityPlayer targetEntity;
    private boolean disableAtSunrise = true;

    public EntityAINearestAttackablePlayerOmniscience() {
        this.shouldCheckSight = false;
        this.nearbyOnly = false;
        this.targetClass = EntityPlayer.class;
        this.targetChance = 40;
        this.func_75248_a(0);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                return !EntitySelectors.field_180132_d.apply(p_apply_1_) ? false : EntityAINearestAttackablePlayerOmniscience.this.isPlayerItSpawnedForOrBlank((EntityLivingBase)p_apply_1_);
            }
        };
    }

    protected boolean isPlayerItSpawnedForOrBlank(@Nullable EntityLivingBase target) {
        if (target instanceof EntityPlayer) {
            if (this.taskOwner.getEntityData().func_74764_b(UtilEntityBuffs.dataEntityBuffed_PlayerSpawnedFor)) {
                String spawnName = this.taskOwner.getEntityData().func_74779_i(UtilEntityBuffs.dataEntityBuffed_PlayerSpawnedFor);
                if (spawnName != null && target.func_70005_c_().equals(spawnName)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.taskOwner.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.targetEntity = this.taskOwner.field_70170_p.func_184150_a(this.taskOwner.field_70165_t, this.taskOwner.field_70163_u + (double)this.taskOwner.func_70047_e(), this.taskOwner.field_70161_v, this.getTargetDistance(), this.getTargetDistance(), null, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    @Override
    protected double getTargetDistance() {
        return 9999.0;
    }

    @Override
    public void func_75249_e() {
        this.taskOwner.func_70624_b((EntityLivingBase)this.targetEntity);
        super.func_75249_e();
    }

    @Override
    public void setEntity(EntityCreature creature) {
        this.taskOwner = creature;
        this.sorter = new Sorter((Entity)creature);
    }

    @Override
    public boolean shouldBeRemoved() {
        if (this.disableAtSunrise && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && this.taskOwner.field_70170_p.func_72935_r()) {
            CULog.dbg("removing omniscience from " + this.taskOwner.func_70005_c_());
            if (this.taskOwner.func_70638_az() instanceof EntityPlayer) {
                this.taskOwner.func_70624_b(null);
            }
            return true;
        }
        return false;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.entity.func_70068_e(p_compare_1_);
            if (d0 < (d1 = this.entity.func_70068_e(p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

