/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty;

import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.difficulty.BuffedLocation;
import CoroUtil.difficulty.DamageSourceEntry;
import CoroUtil.entity.data.AttackData;
import CoroUtil.forge.CULog;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilWorldTime;
import CoroUtil.util.UtilPlayer;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import CoroUtil.world.location.ISimulationTickable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;

public class DynamicDifficulty {
    public static String dataPlayerServerTicks = "HW_dataPlayerServerTicks";
    public static String dataPlayerLastCacheEquipmentRating = "HW_dataPlayerLastCacheEquipmentRating";
    public static String dataPlayerHarvestOre = "HW_dataPlayerHarvestOre";
    public static String dataPlayerHarvestLog = "HW_dataPlayerHarvestLog";
    public static String dataPlayerHarvestRating = "HW_dataPlayerHarvestRating";
    public static String dataPlayerDetectInAirTime = "HW_dataPlayerDetectInAirTime";
    public static String dataPlayerInvasionSkipping = "HW_dataPlayerInvasionSkipping";
    public static String dataPlayerInvasionSkipCount = "HW_dataPlayerInvasionSkipCount";
    public static String dataPlayerInvasionSkipCountForMultiplier = "HW_dataPlayerInvasionSkipCountForMultiplier";
    public static String dataPlayerInvasionSkippingTooSoon = "HW_dataPlayerInvasionSkippingTooSoon";
    public static String dataPlayerInvasionSkipBuff = "HW_dataPlayerInvasionSkipBuff";
    private static int tickRate = 20;
    public static HashMap<Integer, AttackData> lookupEntToDamageLog = new HashMap();
    public static List<String> listBlacklistedDamageSources = new ArrayList<String>();

    public static void tickServer(TickEvent.ServerTickEvent event) {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world != null) {
            long dayNumber;
            for (Object player : world.field_73010_i) {
                if (!(player instanceof EntityPlayer)) continue;
                DynamicDifficulty.tickPlayer((EntityPlayer)player);
            }
            if (ConfigCoroUtilAdvanced.cleanupStrayMobs && (dayNumber = world.func_72820_D() / (long)CoroUtilWorldTime.getDayLength() + 1L) % (long)ConfigCoroUtilAdvanced.cleanupStrayMobsDayRate == 0L) {
                long timeOfDay = world.func_72820_D() % (long)CoroUtilWorldTime.getDayLength();
                int killTimeRange = 10;
                if (timeOfDay >= (long)ConfigCoroUtilAdvanced.cleanupStrayMobsTimeOfDay && timeOfDay < (long)(2000 + killTimeRange)) {
                    CULog.dbg("KILLING ALL ZOMBIES!");
                    for (Object obj : world.field_72996_f) {
                        if (!(obj instanceof EntityZombie)) continue;
                        ((EntityZombie)obj).func_70106_y();
                    }
                }
            }
        }
    }

    public static void tickPlayer(EntityPlayer player) {
        World world = player.field_70170_p;
        if (!player.func_175149_v() && !player.func_184812_l_() && world.func_82737_E() % (long)tickRate == 0L) {
            long ticksPlayed = player.getEntityData().func_74763_f(dataPlayerServerTicks);
            player.getEntityData().func_74772_a(dataPlayerServerTicks, ticksPlayed += (long)tickRate);
        }
        int wallScanRange = 3;
        boolean autoAttackTest = true;
        boolean isInAir = false;
        boolean dbg = false;
        if (dbg) {
            System.out.println("player tick");
        }
        if (!player.field_71075_bZ.field_75098_d || autoAttackTest) {
            if (dbg) {
                System.out.println("1");
            }
            if (player.field_71075_bZ.field_75100_b || !player.field_70122_E && !player.func_70090_H() && !player.func_70055_a(Material.field_151587_i)) {
                if (dbg) {
                    System.out.println("2");
                }
                if (player.func_184187_bx() == null) {
                    if (dbg) {
                        System.out.println("3");
                    }
                    Block block = null;
                    int pX = MathHelper.func_76128_c((double)player.field_70165_t);
                    int pY = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
                    int pZ = MathHelper.func_76128_c((double)player.field_70161_v);
                    boolean foundWall = false;
                    for (int x = -wallScanRange; !foundWall && x <= wallScanRange; ++x) {
                        block1: for (int z = -wallScanRange; !foundWall && z <= wallScanRange; ++z) {
                            for (int y = -wallScanRange; !foundWall && y <= wallScanRange; ++y) {
                                BlockPos pos = new BlockPos(pX + x, pY + y, pZ + z);
                                IBlockState state = world.func_180495_p(pos);
                                block = state.func_177230_c();
                                if (block.isAir(state, (IBlockAccess)world, pos)) continue;
                                ArrayList list = new ArrayList();
                                block.func_185477_a(state, world, new BlockPos(pX + x, pY + y, pZ + z), player.func_174813_aQ(), list, (Entity)player, true);
                                if (list.size() <= 0) continue;
                                if (dbg) {
                                    System.out.println("wall found - " + block + " - " + (pX + x) + ", " + (pY + y) + ", " + (pZ + z));
                                }
                                foundWall = true;
                                continue block1;
                            }
                        }
                    }
                    if (!foundWall) {
                        if (dbg) {
                            System.out.println("no wall found");
                        }
                        isInAir = true;
                    }
                }
            }
        }
        if (isInAir) {
            if (dbg) {
                System.out.println("in air");
            }
            long airTime = player.getEntityData().func_74763_f(dataPlayerDetectInAirTime);
            player.getEntityData().func_74772_a(dataPlayerDetectInAirTime, airTime + 1L);
        } else {
            if (dbg) {
                System.out.println("not in air");
            }
            player.getEntityData().func_74772_a(dataPlayerDetectInAirTime, 0L);
        }
    }

    public static void deathPlayer(EntityPlayer player) {
        WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(player.field_70170_p);
        if (wd != null) {
            BuffedLocation debuff = new BuffedLocation(32, -2.0f);
            debuff.setDecays(true);
            debuff.setWorldID(player.field_70170_p.field_73011_w.getDimension());
            debuff.setOrigin(new BlockCoord(player.func_180425_c()));
            wd.addTickingLocation(debuff);
        }
    }

    public static float getDifficultyAveragedForArea(EntityCreature spawnedEntity) {
        return DynamicDifficulty.getDifficultyAveragedForArea(spawnedEntity, spawnedEntity.func_180425_c());
    }

    public static float getDifficultyAveragedForArea(EntityCreature spawnedEntity, BlockPos pos) {
        return DynamicDifficulty.getDifficultyAveragedForArea(spawnedEntity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static float getDifficultyAveragedForArea(EntityCreature spawnedEntity, int x, int y, int z) {
        EntityPlayer player = spawnedEntity.field_70170_p.func_72890_a((Entity)spawnedEntity, -1.0);
        if (player != null) {
            return DynamicDifficulty.getDifficultyScaleAverage(player, x, y, z);
        }
        return 0.0f;
    }

    public static float getDifficultyScaleAverage(EntityPlayer player, int x, int y, int z) {
        return DynamicDifficulty.getDifficultyScaleAverage(player, new BlockCoord(x, y, z));
    }

    public static float getDifficultyScaleAverage(World world, EntityPlayer player, BlockCoord pos) {
        return DynamicDifficulty.getDifficultyScaleAverage(player, pos);
    }

    public static float getDifficultyScaleAverage(EntityPlayer player, BlockCoord pos) {
        World world = player.field_70170_p;
        float weightPosOccupy = (float)ConfigDynamicDifficulty.weightPosOccupy;
        float weightPlayerEquipment = (float)ConfigDynamicDifficulty.weightPlayerEquipment;
        float weightPlayerServerTime = (float)ConfigDynamicDifficulty.weightPlayerServerTime;
        float weightDPS = (float)ConfigDynamicDifficulty.weightDPS;
        float weightDistFromSpawn = (float)ConfigDynamicDifficulty.weightDistFromSpawn;
        float weightHealth = (float)ConfigDynamicDifficulty.weightHealth;
        float weightBuffedLocation = (float)ConfigDynamicDifficulty.weightBuffedLocation;
        float weightDebuffedLocation = (float)ConfigDynamicDifficulty.weightDebuffedLocation;
        float weightTotal = weightPosOccupy + weightPlayerEquipment + weightPlayerServerTime + weightDPS + weightDistFromSpawn;
        float difficultyPosOccupy = DynamicDifficulty.getDifficultyScaleForPosOccupyTime(world, pos) * weightPosOccupy;
        float difficultyPlayerEquipment = DynamicDifficulty.getDifficultyScaleForPlayerEquipment(player) * weightPlayerEquipment;
        float difficultyPlayerServerTime = DynamicDifficulty.getDifficultyScaleForPlayerServerTime(player) * weightPlayerServerTime;
        float difficultyDPS = DynamicDifficulty.getDifficultyScaleForPosDPS(world, pos) * weightDPS;
        float difficultyHealth = DynamicDifficulty.getDifficultyScaleForHealth(player) * weightHealth;
        float difficultyDistFromSpawn = DynamicDifficulty.getDifficultyScaleForDistFromSpawn(player) * weightDistFromSpawn;
        float difficultyBuffedLocation = DynamicDifficulty.getDifficultyForBuffedLocation(world, pos) * weightBuffedLocation;
        float difficultyDebuffedLocation = DynamicDifficulty.getDifficultyForDebuffedLocation(world, pos) * weightDebuffedLocation;
        float difficultyBuffInvasionSkip = DynamicDifficulty.getInvasionSkipBuff(player);
        float difficultyTotal = difficultyPosOccupy + difficultyPlayerEquipment + difficultyPlayerServerTime + difficultyDPS + difficultyHealth + difficultyDistFromSpawn + difficultyBuffedLocation;
        difficultyTotal += difficultyDebuffedLocation;
        float val = (difficultyTotal += difficultyBuffInvasionSkip) / weightTotal;
        val = (float)Math.round(val * 1000.0f) / 1000.0f;
        if (ConfigDynamicDifficulty.difficulty_Max != -1.0 && (double)val > ConfigDynamicDifficulty.difficulty_Max) {
            val = (float)ConfigDynamicDifficulty.difficulty_Max;
        }
        if (val < 0.0f) {
            val = 0.0f;
        }
        return val;
    }

    public static float getDifficultyScaleForPlayerServerTime(EntityPlayer player) {
        long maxServerTime = ConfigDynamicDifficulty.difficulty_MaxTicksOnServer;
        long curServerTime = player.getEntityData().func_74763_f(dataPlayerServerTicks);
        return (float)Math.round(MathHelper.func_76131_a((float)((float)curServerTime / (float)maxServerTime), (float)0.0f, (float)1.0f) * 1000.0f) / 1000.0f;
    }

    public static float getDifficultyScaleForPlayerEquipment(EntityPlayer player) {
        boolean calcWeapon = false;
        int curRating = 0;
        if (player.getEntityData().func_74764_b(dataPlayerLastCacheEquipmentRating)) {
            if (player.field_70170_p.func_82737_E() % 200L == 0L) {
                curRating = UtilPlayer.getPlayerRating(player, calcWeapon);
                player.getEntityData().func_74768_a(dataPlayerLastCacheEquipmentRating, curRating);
            } else {
                curRating = player.getEntityData().func_74762_e(dataPlayerLastCacheEquipmentRating);
            }
        } else {
            curRating = UtilPlayer.getPlayerRating(player, calcWeapon);
            player.getEntityData().func_74768_a(dataPlayerLastCacheEquipmentRating, curRating);
        }
        int bestRating = DynamicDifficulty.getBestPlayerRatingPossibleVanilla(calcWeapon);
        return (float)curRating / (float)bestRating;
    }

    public static float getDifficultyScaleForHealth(EntityPlayer player) {
        float baseMax = ConfigDynamicDifficulty.difficulty_BestVanillaHealth;
        float curMax = player.func_110138_aP();
        float scale = curMax / baseMax;
        return scale - 1.0f;
    }

    public static float getDifficultyScaleForDistFromSpawn(EntityPlayer player) {
        float distX = (float)((double)player.field_70170_p.func_175694_M().func_177958_n() - player.field_70165_t);
        float distZ = (float)((double)player.field_70170_p.func_175694_M().func_177952_p() - player.field_70161_v);
        float dist = (float)Math.sqrt(distX * distX + distZ * distZ);
        dist = Math.min(dist, (float)ConfigDynamicDifficulty.difficulty_DistFromSpawnMax);
        return dist / (float)ConfigDynamicDifficulty.difficulty_DistFromSpawnMax;
    }

    public static int getBestPlayerRatingPossibleVanilla(boolean calcWeapon) {
        int bestArmor = ConfigDynamicDifficulty.difficulty_BestVanillaArmor;
        int bestArmorEnchant = ConfigDynamicDifficulty.difficulty_BestVanillaArmorEnchant;
        int bestWeapon = 8;
        int bestWeaponEnchant = 6;
        if (!calcWeapon) {
            bestWeapon = 0;
            bestWeaponEnchant = 0;
        }
        int bestVal = bestArmor + bestArmorEnchant + bestWeapon + bestWeaponEnchant;
        return bestVal;
    }

    public static float getBestPlayerDPSRatingPossibleVanilla() {
        return ConfigDynamicDifficulty.difficulty_BestVanillaDPS;
    }

    public static float getDifficultyScaleForPosDPS(World world, BlockCoord pos) {
        return DynamicDifficulty.getDifficultyScaleForPosDPS(world, pos, false, null);
    }

    public static float getDifficultyScaleForPosDPS(World world, BlockCoord pos, boolean extraDebug, EntityPlayer playerToMsg) {
        int chunkRange = ConfigDynamicDifficulty.difficulty_BestDPSChunkRadius;
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        float bestDPS = 0.0f;
        DamageSourceEntry bestSource = null;
        for (int x = chunkX - chunkRange; x <= chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z <= chunkZ + chunkRange; ++z) {
                Chunk chunk;
                BlockCoord checkPos = new BlockCoord(x * 16 + 8, 128, z * 16 + 8);
                if (!world.func_175667_e(checkPos.toBlockPos()) || (chunk = world.func_175726_f(new BlockPos(checkPos.posX, checkPos.posY, checkPos.posZ))) == null) continue;
                ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(x, z);
                if (extraDebug) {
                    DynamicDifficulty.dbgHighDamage("dps debug output for " + x + ", " + z + ": " + cdp.highestDamage.toString());
                }
                if (!(cdp.averageDPS > bestDPS)) continue;
                bestDPS = cdp.averageDPS;
                bestSource = cdp.highestDamage;
            }
        }
        if (bestSource != null && playerToMsg != null) {
            playerToMsg.func_145747_a((ITextComponent)new TextComponentString("Best average dps found:"));
            playerToMsg.func_145747_a((ITextComponent)new TextComponentString(bestSource.toString()));
        }
        float scale = DynamicDifficulty.convertDPSToDifficultyScale(bestDPS);
        return scale;
    }

    public static void setDifficultyScaleForPosDPS(World world, BlockCoord pos, float dps, int chunkRange) {
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Chunk chunk;
                BlockCoord checkPos = new BlockCoord(x * 16 + 8, 128, z * 16 + 8);
                if (!world.func_175667_e(checkPos.toBlockPos()) || (chunk = world.func_175726_f(new BlockPos(checkPos.posX, checkPos.posY, checkPos.posZ))) == null) continue;
                ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(x, z);
                cdp.averageDPS = dps;
                cdp.lastDPSRecalc = 0L;
                cdp.listDPSAveragesShortTerm.clear();
                cdp.listDPSAveragesLongTerm.clear();
                cdp.highestDamage = new DamageSourceEntry();
                cdp.highestDamage.source_type = "<COMMAND SET>";
            }
        }
    }

    public static float convertDPSToDifficultyScale(float dps) {
        float scale = dps / DynamicDifficulty.getBestPlayerDPSRatingPossibleVanilla();
        if ((double)scale > ConfigCoroUtilAdvanced.difficulty_MaxDPSRatingAllowed) {
            scale = (float)ConfigCoroUtilAdvanced.difficulty_MaxDPSRatingAllowed;
        }
        return scale;
    }

    public static float getDifficultyScaleForPosOccupyTime(World world, BlockCoord pos) {
        int chunkRange = 3;
        int chunkX = pos.getX() / 16;
        int chunkZ = pos.getZ() / 16;
        int count = 0;
        long totalTime = 0L;
        for (int x = chunkX - chunkRange; x < chunkX + chunkRange; ++x) {
            for (int z = chunkZ - chunkRange; z < chunkZ + chunkRange; ++z) {
                Chunk chunk;
                BlockCoord checkPos = new BlockCoord(x * 16 + 8, 128, z * 16 + 8);
                if (!world.func_175667_e(checkPos.toBlockPos()) || (chunk = world.func_175726_f(new BlockPos(checkPos.posX, checkPos.posY, checkPos.posZ))) == null) continue;
                totalTime += chunk.func_177416_w();
                ++count;
            }
        }
        long averageTime = 0L;
        if (count > 0) {
            averageTime = totalTime / (long)count;
        }
        float scale = DynamicDifficulty.convertInhabTimeToDifficultyScale(averageTime);
        return (float)Math.round(scale * 1000.0f) / 1000.0f;
    }

    public static float getInvasionSkipBuff(EntityPlayer player) {
        return player.getEntityData().func_74760_g(dataPlayerInvasionSkipBuff);
    }

    public static void setInvasionSkipBuff(EntityPlayer player, float buff) {
        player.getEntityData().func_74776_a(dataPlayerInvasionSkipBuff, buff);
    }

    public static float convertInhabTimeToDifficultyScale(long inhabTime) {
        float scale = (float)inhabTime / (float)ConfigDynamicDifficulty.difficulty_MaxTicksInChunk;
        return scale;
    }

    public static void handleHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && event.getWorld().field_73010_i.contains(event.getHarvester())) {
            NBTTagCompound nbt = event.getHarvester().getEntityData();
            if (event.getState() != null && event.getState().func_177230_c() instanceof BlockOre) {
                int curVal = nbt.func_74762_e(dataPlayerHarvestOre);
                nbt.func_74768_a(dataPlayerHarvestOre, ++curVal);
            } else if (event.getState() != null && event.getState().func_177230_c() instanceof BlockLog) {
                int curVal = nbt.func_74762_e(dataPlayerHarvestLog);
                nbt.func_74768_a(dataPlayerHarvestLog, ++curVal);
            }
            DynamicDifficulty.increaseInvadeRating(event.getHarvester(), DynamicDifficulty.getBlockImportanceValue(event.getState().func_177230_c()));
        }
    }

    public static void increaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = parPlayer.getEntityData();
        float curVal = nbt.func_74760_g(dataPlayerHarvestRating);
        nbt.func_74776_a(dataPlayerHarvestRating, curVal += parVal);
    }

    public static void decreaseInvadeRating(EntityPlayer parPlayer, float parVal) {
        NBTTagCompound nbt = parPlayer.getEntityData();
        float curVal = nbt.func_74760_g(dataPlayerHarvestRating);
        nbt.func_74776_a(dataPlayerHarvestRating, curVal -= parVal);
    }

    public static float getHarvestRatingInvadeThreshold() {
        return 30.0f;
    }

    public static boolean isInvadeable(EntityPlayer parPlayer) {
        return parPlayer.getEntityData().func_74760_g(dataPlayerHarvestRating) >= DynamicDifficulty.getHarvestRatingInvadeThreshold();
    }

    public static float getBlockImportanceValue(Block block) {
        try {
            boolean test = false;
            if (test) {
                System.out.println("TEST INVADE IS ON!");
                return 30.0f;
            }
            float scaleBase = 1.0f;
            float defaultIron = scaleBase * 0.3f;
            if (block instanceof BlockLog) {
                return scaleBase * 0.1f;
            }
            if (block instanceof BlockSapling) {
                return scaleBase * 0.3f;
            }
            if (block instanceof BlockOre) {
                if (block == Blocks.field_150365_q) {
                    return scaleBase * 0.2f;
                }
                if (block == Blocks.field_150366_p) {
                    return defaultIron;
                }
                if (block == Blocks.field_150352_o) {
                    return scaleBase * 0.4f;
                }
                if (block == Blocks.field_150439_ay || block == Blocks.field_150450_ax) {
                    return scaleBase * 0.5f;
                }
                if (block == Blocks.field_150369_x) {
                    return scaleBase * 0.6f;
                }
                if (block == Blocks.field_150482_ag) {
                    return scaleBase * 1.0f;
                }
                if (block == Blocks.field_150412_bA) {
                    return scaleBase * 1.2f;
                }
                return defaultIron;
            }
            if (OreDictionary.getOres((String)((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString()).size() > 0) {
                return defaultIron;
            }
            return 0.0f;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static EntityPlayer getBestPlayerForArea(World world, BlockCoord pos) {
        EntityPlayer player = world.func_184137_a((double)pos.posX, (double)pos.posY, (double)pos.posZ, -1.0, false);
        return player;
    }

    public static void logDamage(LivingHurtEvent event) {
        boolean tempLog = ConfigCoroUtilAdvanced.logging_DPS_All;
        if (tempLog) {
            try {
                System.out.println("LivingHurtEvent: ");
                System.out.println("type: " + event.getSource().field_76373_n);
                if (event.getSource().func_76364_f() != null) {
                    System.out.println("source immediate: " + event.getSource().func_76364_f().func_70005_c_());
                }
                if (event.getSource().func_76346_g() != null) {
                    System.out.println("source true: " + event.getSource().func_76346_g().func_70005_c_());
                }
                System.out.println("amount: " + event.getAmount());
                Throwable t = new Throwable();
                t.printStackTrace();
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigCoroUtilAdvanced.trackChunkData) {
            Entity ent = event.getEntity();
            World world = ent.field_70170_p;
            if (ent instanceof EntityCreature && (!ConfigDynamicDifficulty.difficulty_OnlyLogDPSToHostiles || ent instanceof IMob)) {
                AttackData log;
                EntityCreature entC = (EntityCreature)ent;
                if (ConfigDynamicDifficulty.difficulty_DontLogDPSFromEnvironment && (event.getSource() == DamageSource.field_76368_d || event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76369_e || event.getSource() == DamageSource.field_76379_h)) {
                    DynamicDifficulty.dbgDPS("bad damage type, skipping: " + event.getSource());
                    return;
                }
                if (event.getSource() == DamageSource.field_76380_i) {
                    return;
                }
                if (ConfigDynamicDifficulty.difficulty_OnlyLogDPSFromPlayerAsSource && !(event.getSource().func_76364_f() instanceof EntityPlayer) && !(event.getSource().func_76346_g() instanceof EntityPlayer)) {
                    return;
                }
                if (event.getSource().func_76346_g() instanceof EntityLiving) {
                    if (event.getSource().func_76346_g() instanceof IEntityOwnable) {
                        if (!(((IEntityOwnable)event.getSource().func_76346_g()).func_70902_q() instanceof EntityPlayer)) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (listBlacklistedDamageSources.size() > 0) {
                    if (DynamicDifficulty.stringEqualsItemFromList(event.getSource().field_76373_n, listBlacklistedDamageSources)) {
                        DynamicDifficulty.dbgDPS("Detected blacklisted damage type, skipping: " + event.getSource().field_76373_n);
                        return;
                    }
                    if (event.getSource().func_76346_g() != null && DynamicDifficulty.stringEqualsItemFromList(event.getSource().func_76346_g().func_70005_c_(), listBlacklistedDamageSources)) {
                        DynamicDifficulty.dbgDPS("Detected blacklisted entity name for true source, skipping: " + event.getSource().func_76346_g().func_70005_c_());
                        return;
                    }
                    if (event.getSource().func_76364_f() != null && DynamicDifficulty.stringEqualsItemFromList(event.getSource().func_76364_f().func_70005_c_(), listBlacklistedDamageSources)) {
                        DynamicDifficulty.dbgDPS("Detected blacklisted entity name immediate source, skipping: " + event.getSource().func_76364_f().func_70005_c_());
                        return;
                    }
                }
                if (!lookupEntToDamageLog.containsKey(ent.func_145782_y())) {
                    log = new AttackData(entC);
                    lookupEntToDamageLog.put(ent.func_145782_y(), log);
                } else {
                    int lastLogTimeThreshold = 100;
                    log = lookupEntToDamageLog.get(ent.func_145782_y());
                    if (log.getLastLogTime() + (long)lastLogTimeThreshold < world.func_82737_E()) {
                        DynamicDifficulty.logToChunk(log);
                        log.cleanup();
                        log = new AttackData(entC);
                        lookupEntToDamageLog.put(ent.func_145782_y(), log);
                    } else if (!log.isSameSource(event.getSource())) {
                        DynamicDifficulty.dbgDPS("damage source mismatch, resetting");
                        DynamicDifficulty.logToChunk(log);
                        log.cleanup();
                        log = new AttackData(entC);
                        lookupEntToDamageLog.put(ent.func_145782_y(), log);
                    }
                }
                float damageToLog = event.getAmount();
                float timeDiffSeconds = 0.0f;
                float damage = 0.0f;
                boolean bigDamage = false;
                if (log.getLastDamage() > 0.0f) {
                    long timeDiff = world.func_82737_E() - log.getLastLogTime();
                    if (timeDiff != 0L && ConfigCoroUtilAdvanced.difficulty_MaxAttackSpeedLoggable != -1.0 && (double)timeDiff < ConfigCoroUtilAdvanced.difficulty_MaxAttackSpeedLoggable) {
                        DynamicDifficulty.dbgDPS("DPS WARNING: detected high hit rate of " + timeDiff + ", adjusting to max allowed rate of " + ConfigCoroUtilAdvanced.difficulty_MaxAttackSpeedLoggable);
                        timeDiff = (long)ConfigCoroUtilAdvanced.difficulty_MaxAttackSpeedLoggable;
                    }
                    timeDiffSeconds = (float)timeDiff / 20.0f;
                    if (timeDiff > 0L) {
                        damage = log.getLastDamage() / timeDiffSeconds;
                        if (ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable != -1.0 && (double)damage > ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable) {
                            damage = (float)ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable;
                            DynamicDifficulty.dbgDPS("DPS WARNING: !!!!!!!!!!!!!! we hit a max loggable damage scenario!!!!!!!!!");
                            bigDamage = true;
                        }
                        if (damage > (float)ConfigDynamicDifficulty.difficulty_BestVanillaDPS) {
                            DynamicDifficulty.dbgDPS("DPS WARNING: !!! damage was greater than expected vanilla capabilities!!!");
                            bigDamage = true;
                        }
                        log.getListDPSs().add(Float.valueOf(damage));
                    } else {
                        damageToLog += log.getLastDamage();
                    }
                }
                if (bigDamage) {
                    String source = "null";
                    if (event.getSource().func_76346_g() != null) {
                        source = event.getSource().func_76346_g().getClass().getSimpleName();
                    }
                    DynamicDifficulty.dbgDPS("logging damageToLog: " + damageToLog + " damage: " + damage + ", log.getLastDamage(): " + log.getLastDamage() + " to " + entC.getClass().getSimpleName() + " by source " + source + " with " + event.getSource().field_76373_n + " timediffinsecs: " + timeDiffSeconds);
                }
                log.trackSources(event.getSource());
                log.setLastDamage(damageToLog);
                log.setLastLogTime(world.func_82737_E());
                if (damageToLog > log.highestDamage.highestDamage) {
                    log.highestDamage.highestDamage = damageToLog;
                    log.highestDamage.damageTimeAveraged = damage;
                    log.highestDamage.source_type = log.getSource_type();
                    log.highestDamage.source_entity_true = log.getSource_entityTrue() != null ? log.getSource_entityTrue().getClass().getSimpleName() + ", entity_name: " + log.getSource_entityTrue().func_70005_c_() : "<NULL>";
                    log.highestDamage.source_entity_immediate = log.getSource_entityImmediate() != null ? log.getSource_entityImmediate().getClass().getSimpleName() + ", entity_name: " + log.getSource_entityImmediate().func_70005_c_() : "<NULL>";
                    log.highestDamage.target_entity = ent != null ? ent.getClass().getSimpleName() + ", entity_name: " + ent.func_70005_c_() : "<NULL>";
                    log.highestDamage.lastLogTime = log.getLastLogTime();
                    log.highestDamage.timeDiffSeconds = timeDiffSeconds;
                    log.highestDamage.source_pos = ent.func_180425_c();
                }
            }
        }
    }

    public static void logDeath(LivingDeathEvent event) {
        AttackData log;
        Entity ent;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigCoroUtilAdvanced.trackChunkData && (ent = event.getEntity()) instanceof EntityCreature && (!ConfigDynamicDifficulty.difficulty_OnlyLogDPSToHostiles || ent instanceof IMob) && lookupEntToDamageLog.containsKey(ent.func_145782_y()) && (log = lookupEntToDamageLog.get(ent.func_145782_y())) != null) {
            DynamicDifficulty.logToChunk(log);
            log.cleanup();
            lookupEntToDamageLog.remove(ent.func_145782_y());
        }
    }

    public static void logToChunk(AttackData log) {
        int maxShortTermSize = 50;
        int maxLongTermSize = 50;
        int recalcRate = 40;
        EntityCreature ent = log.getEnt();
        World world = ent.field_70170_p;
        int chunkX = MathHelper.func_76128_c((double)(ent.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(ent.field_70161_v / 16.0));
        ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(world).getChunkData(chunkX, chunkZ);
        if (log.getListDPSs().size() == 0 && log.getLastDamage() > 0.0f) {
            float instaKillDPSCalc = log.getLastDamage() * 2.0f;
            if (ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable != -1.0 && (double)instaKillDPSCalc > ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable) {
                instaKillDPSCalc = (float)ConfigCoroUtilAdvanced.difficulty_MaxDPSLoggable;
            }
            DynamicDifficulty.dbgDPS("logging one time hit of: " + instaKillDPSCalc);
            log.getListDPSs().add(Float.valueOf(instaKillDPSCalc));
        }
        if (log.getListDPSs().size() > 0) {
            float avgDPS = 0.0f;
            for (float val : log.getListDPSs()) {
                avgDPS += val;
            }
            DynamicDifficulty.dbgDPS("logging short term average: " + (avgDPS /= (float)log.getListDPSs().size()));
            cdp.listDPSAveragesShortTerm.add(Float.valueOf(avgDPS));
            if (log.getLastDamage() > cdp.highestDamage.highestDamage) {
                cdp.highestDamage = log.highestDamage;
                DynamicDifficulty.dbgHighDamage("New highest damage for chunk " + chunkX + ", " + chunkZ + ": " + log.highestDamage.toString());
            }
        }
        if (cdp.listDPSAveragesShortTerm.size() > maxShortTermSize) {
            cdp.listDPSAveragesShortTerm.remove(0);
        }
        if (cdp.lastDPSRecalc + (long)recalcRate < world.func_82737_E()) {
            if (cdp.listDPSAveragesShortTerm.size() > 0) {
                float avgDPS2 = 0.0f;
                for (float val : cdp.listDPSAveragesShortTerm) {
                    avgDPS2 += val;
                }
                DynamicDifficulty.dbgDPS("logging long term average: " + (avgDPS2 /= (float)cdp.listDPSAveragesShortTerm.size()));
                cdp.listDPSAveragesLongTerm.add(Float.valueOf(avgDPS2));
            }
            if (cdp.listDPSAveragesLongTerm.size() > maxLongTermSize) {
                cdp.listDPSAveragesLongTerm.remove(0);
            }
            if (cdp.listDPSAveragesLongTerm.size() > 0) {
                float avgDPS3 = 0.0f;
                for (float val : cdp.listDPSAveragesLongTerm) {
                    avgDPS3 += val;
                }
                DynamicDifficulty.dbgDPS("logging chunk dps average: " + (avgDPS3 /= (float)cdp.listDPSAveragesLongTerm.size()));
                cdp.averageDPS = avgDPS3;
            }
            cdp.lastDPSRecalc = world.func_82737_E();
        }
    }

    public static BuffedLocation buffLocation(World world, BlockCoord coord, int distRadius, float difficulty) {
        BuffedLocation zone = new BuffedLocation(distRadius, difficulty);
        zone.setWorldID(world.field_73011_w.getDimension());
        zone.setOrigin(coord);
        WorldDirectorManager.instance().getCoroUtilWorldDirector(world).addTickingLocation(zone);
        return zone;
    }

    public static float getDifficultyForDebuffedLocation(World world, BlockCoord coord) {
        return DynamicDifficulty.getDifficultyForBuffedLocation(world, coord, true);
    }

    public static float getDifficultyForBuffedLocation(World world, BlockCoord coord) {
        return DynamicDifficulty.getDifficultyForBuffedLocation(world, coord, false);
    }

    public static float getDifficultyForBuffedLocation(World world, BlockCoord coord, boolean findDebuffInstead) {
        float bestDifficulty = 0.0f;
        WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(world);
        for (ISimulationTickable loc : wd.listTickingLocations) {
            double dist;
            BuffedLocation buff;
            if (!(loc instanceof BuffedLocation) || (buff = (BuffedLocation)loc).isDebuff() != findDebuffInstead || !((dist = coord.getDistanceSquared(buff.getOrigin())) < (double)(buff.buffDistRadius * buff.buffDistRadius))) continue;
            if (findDebuffInstead) {
                if (!(buff.difficulty < bestDifficulty)) continue;
                bestDifficulty = buff.difficulty;
                continue;
            }
            if (!(buff.difficulty > bestDifficulty)) continue;
            bestDifficulty = buff.difficulty;
        }
        return bestDifficulty;
    }

    public static boolean stringEqualsItemFromList(String inputStr, List<String> items) {
        return items.parallelStream().anyMatch(inputStr::equals);
    }

    public static void dbgDPS(String string) {
        if (ConfigCoroUtilAdvanced.logging_DPS_Fine) {
            CULog.log(string);
        }
    }

    public static void dbgHighDamage(String string) {
        if (ConfigCoroUtilAdvanced.logging_DPS_HighSources) {
            CULog.log(string);
        }
    }
}

