/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Config;

import com.wuest.repurpose.Base.BaseConfig;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RedstoneScannerConfig
extends BaseConfig {
    private ArrayList<FacingConfig> facingConfigs;
    private int tickDelay;
    private BlockPos pos;
    private boolean animalsDetected;
    private boolean nonPlayersDetected;
    private boolean monstersDetected;
    private boolean playersDetected;

    public RedstoneScannerConfig() {
        this.Initialize();
    }

    public ArrayList<FacingConfig> getFacingConfigs() {
        return this.facingConfigs;
    }

    public FacingConfig getFacingConfig(String name) {
        for (FacingConfig config : this.facingConfigs) {
            if (!config.getFacing().func_176742_j().equals(name)) continue;
            return config;
        }
        return null;
    }

    public FacingConfig getFacingConfig(EnumFacing facing) {
        for (FacingConfig config : this.facingConfigs) {
            if (config.getFacing() != facing) continue;
            return config;
        }
        return null;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(int value) {
        if (value < 1) {
            value = 1;
        }
        this.tickDelay = value;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos value) {
        this.pos = value;
    }

    public void setBlockPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    public boolean getAnimalsDetected() {
        return this.animalsDetected;
    }

    public void setAnimalsDetected(boolean value) {
        this.animalsDetected = value;
    }

    public boolean IsFacingActive(EnumFacing facing) {
        FacingConfig config = this.getFacingConfig(facing);
        return config.active;
    }

    public int GetFacingScanLength(EnumFacing facing) {
        FacingConfig config = this.getFacingConfig(facing);
        return config.scanLength;
    }

    public boolean getNonPlayersDetected() {
        return this.nonPlayersDetected;
    }

    public void setNonPlayersDetected(boolean value) {
        this.nonPlayersDetected = value;
    }

    public boolean getMonstersDetected() {
        return this.monstersDetected;
    }

    public void setMonstersDetected(boolean value) {
        this.monstersDetected = value;
    }

    public boolean getPlayersDetected() {
        return this.playersDetected;
    }

    public void setPlayersDetected(boolean value) {
        this.playersDetected = value;
    }

    public void AddFacingConfig(FacingConfig value) {
        this.facingConfigs.add(value);
    }

    public void AddFacingConfig(EnumFacing facing, boolean active, int scanLength) {
        FacingConfig config = new FacingConfig();
        this.AddFacingConfig(config.setFacing(facing).setActive(active).setScanLength(scanLength));
    }

    public void SetFacingConfig(EnumFacing facing, boolean active) {
        this.SetFacingConfig(facing, active, -1);
    }

    public void SetFacingConfig(EnumFacing facing, int scanLength) {
        for (FacingConfig config : this.facingConfigs) {
            if (config.facing != facing) continue;
            config.setScanLength(scanLength);
            break;
        }
    }

    public void SetFacingConfig(EnumFacing facing, boolean active, int scanLength) {
        for (FacingConfig config : this.facingConfigs) {
            if (config.facing != facing) continue;
            config.active = active;
            if (scanLength < 0) break;
            config.scanLength = scanLength;
            break;
        }
    }

    public void Initialize() {
        this.facingConfigs = new ArrayList();
        this.tickDelay = 5;
        this.animalsDetected = false;
        this.nonPlayersDetected = false;
        this.playersDetected = false;
        this.monstersDetected = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            FacingConfig config = new FacingConfig();
            config.setFacing(facing);
            config.setScanLength(1);
            config.setActive(true);
            this.facingConfigs.add(config);
        }
    }

    @Override
    public void WriteToNBTCompound(NBTTagCompound compound) {
        NBTTagCompound configCompound = new NBTTagCompound();
        configCompound.func_74768_a("tickDelay", this.tickDelay);
        if (this.pos != null) {
            compound.func_74768_a("x", this.pos.func_177958_n());
            compound.func_74768_a("y", this.pos.func_177956_o());
            compound.func_74768_a("z", this.pos.func_177952_p());
        }
        configCompound.func_74757_a("detectAnimals", this.animalsDetected);
        configCompound.func_74757_a("detectNonPlayers", this.nonPlayersDetected);
        configCompound.func_74757_a("detectMonsters", this.monstersDetected);
        configCompound.func_74757_a("detectPlayers", this.playersDetected);
        for (FacingConfig config : this.facingConfigs) {
            NBTTagCompound facing = new NBTTagCompound();
            facing.func_74778_a("facing", config.facing.func_176742_j());
            facing.func_74757_a("active", config.active);
            facing.func_74768_a("scanLength", config.scanLength);
            configCompound.func_74782_a(config.facing.func_176742_j(), (NBTBase)facing);
        }
        compound.func_74782_a("configCompound", (NBTBase)configCompound);
    }

    public RedstoneScannerConfig ReadFromNBTTagCompound(NBTTagCompound compound) {
        RedstoneScannerConfig config = new RedstoneScannerConfig();
        if (compound.func_74764_b("configCompound")) {
            NBTTagCompound configCompound = compound.func_74775_l("configCompound");
            if (configCompound.func_74764_b("tickDelay")) {
                config.tickDelay = configCompound.func_74762_e("tickDelay");
            }
            if (configCompound.func_74764_b("detectAnimals")) {
                config.animalsDetected = configCompound.func_74767_n("detectAnimals");
            }
            if (configCompound.func_74764_b("detectNonPlayers")) {
                config.nonPlayersDetected = configCompound.func_74767_n("detectNonPlayers");
            }
            if (configCompound.func_74764_b("detectMonsters")) {
                config.monstersDetected = configCompound.func_74767_n("detectMonsters");
            }
            if (configCompound.func_74764_b("detectPlayers")) {
                config.playersDetected = configCompound.func_74767_n("detectPlayers");
            }
            if (compound.func_74764_b("x") && compound.func_74764_b("y") && compound.func_74764_b("z")) {
                config.pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!configCompound.func_74764_b(facing.func_176742_j())) continue;
                NBTTagCompound tag = configCompound.func_74775_l(facing.func_176742_j());
                FacingConfig facingConfig = new FacingConfig();
                if (tag.func_74764_b("facing")) {
                    facingConfig.facing = EnumFacing.func_176739_a((String)tag.func_74779_i("facing"));
                }
                if (tag.func_74764_b("active")) {
                    facingConfig.active = tag.func_74767_n("active");
                }
                if (tag.func_74764_b("scanLength")) {
                    facingConfig.scanLength = tag.func_74762_e("scanLength");
                }
                config.SetFacingConfig(facingConfig.facing, facingConfig.active, facingConfig.scanLength);
            }
        }
        return config;
    }

    public static class FacingConfig {
        private EnumFacing facing;
        private boolean active;
        private int scanLength;

        public FacingConfig() {
            this.Initialize();
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public FacingConfig setFacing(EnumFacing value) {
            this.facing = value;
            return this;
        }

        public boolean getActive() {
            return this.active;
        }

        public FacingConfig setActive(boolean value) {
            this.active = value;
            return this;
        }

        public int getScanLength() {
            return this.scanLength;
        }

        public FacingConfig setScanLength(int value) {
            if (value <= 0) {
                value = 0;
                this.active = false;
            } else if (this.scanLength == 0 && value >= 1) {
                this.active = true;
            }
            this.scanLength = value;
            return this;
        }

        public void Initialize() {
            this.facing = EnumFacing.NORTH;
            this.active = false;
            this.scanLength = 1;
        }
    }
}

