/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Tiles;

import com.wuest.repurpose.Base.TileEntityBase;
import com.wuest.repurpose.Blocks.BlockRedstoneScanner;
import com.wuest.repurpose.Config.RedstoneScannerConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityRedstoneScanner
extends TileEntityBase<RedstoneScannerConfig> {
    protected boolean foundEntity = false;

    public TileEntityRedstoneScanner() {
        this.config = new RedstoneScannerConfig();
    }

    public int getRedstoneStrength() {
        return this.foundEntity ? 15 : 0;
    }

    public int getTickDelay() {
        return ((RedstoneScannerConfig)this.config).getTickDelay();
    }

    public IBlockState setRedstoneStrength(IBlockState state) {
        this.ScanForEntities();
        return state.func_177226_a((IProperty)BlockRedstoneScanner.POWERED, (Comparable)Boolean.valueOf(this.foundEntity));
    }

    protected void ScanForEntities() {
        int verticalRange = (((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.UP) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.UP) : 0) + (((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.DOWN) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.DOWN) : 0);
        BlockPos startingPos = this.field_174879_c.func_177981_b(((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.UP) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.UP) : 0);
        int northScanRange = ((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.NORTH) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.NORTH) : 0;
        int eastScanRange = ((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.EAST) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.EAST) : 0;
        int southScanRange = ((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.SOUTH) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.SOUTH) : 0;
        int westScanRange = ((RedstoneScannerConfig)this.config).IsFacingActive(EnumFacing.WEST) ? ((RedstoneScannerConfig)this.config).GetFacingScanLength(EnumFacing.WEST) : 0;
        boolean foundATarget = false;
        for (int i = 0; i <= verticalRange && !(foundATarget = this.ScanLevel(northScanRange, eastScanRange, southScanRange, westScanRange, startingPos)); ++i) {
            startingPos = startingPos.func_177977_b();
        }
        this.foundEntity = foundATarget;
    }

    protected boolean ScanLevel(int northScanRange, int eastScanRange, int southScanRange, int westScanRange, BlockPos startingPos) {
        boolean foundATarget = false;
        BlockPos endingPos = startingPos;
        if (northScanRange > 0) {
            startingPos = startingPos.func_177964_d(northScanRange);
        }
        if (eastScanRange > 0) {
            startingPos = startingPos.func_177965_g(eastScanRange);
        }
        if (southScanRange > 0) {
            endingPos = endingPos.func_177970_e(southScanRange);
        }
        if (westScanRange > 0) {
            endingPos = endingPos.func_177985_f(westScanRange);
        }
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)startingPos, (BlockPos)endingPos)) {
            AxisAlignedBB axisPos = Block.field_185505_j.func_186670_a(currentPos);
            List list = this.field_145850_b.func_72839_b((Entity)null, axisPos);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (((RedstoneScannerConfig)this.config).getAnimalsDetected() && entity instanceof IAnimals) {
                        foundATarget = true;
                        break;
                    }
                    if (((RedstoneScannerConfig)this.config).getNonPlayersDetected() && entity instanceof INpc) {
                        foundATarget = true;
                        break;
                    }
                    if (((RedstoneScannerConfig)this.config).getMonstersDetected() && entity instanceof IMob) {
                        foundATarget = true;
                        break;
                    }
                    if (!((RedstoneScannerConfig)this.config).getPlayersDetected() || !(entity instanceof EntityPlayer)) continue;
                    foundATarget = true;
                    break;
                }
            }
            if (!foundATarget) continue;
            break;
        }
        return foundATarget;
    }
}

