/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.dothack.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mod.azure.dothack.DotHackMod;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootHandler {
    private static final List<String> TABLES = ImmutableList.of((Object)"inject/abandoned_mineshaft", (Object)"inject/desert_pyramid", (Object)"inject/jungle_temple", (Object)"inject/simple_dungeon", (Object)"inject/stronghold_crossing", (Object)"inject/stronghold_corridor", (Object)"inject/stronghold_library", (Object)"inject/village_blacksmith", (Object)"inject/main_loot");

    public LootHandler() {
        for (String s : TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rcraft", s));
            DotHackMod.LOGGER.debug("Registered Loot Tables");
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent evt) {
        String prefix = "minecraft:chests/";
        String name = evt.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "simple_dungeon": 
                case "stronghold_crossing": 
                case "stronghold_corridor": 
                case "stronghold_library": 
                case "village_blacksmith": 
                case "main_loot": {
                    evt.getTable().addPool(this.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "rcraft_inject_pool");
    }

    private LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("rcraft", "inject/" + name), weight, 0, new LootCondition[0], "rcraft_inject_entry");
    }
}

