/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestDatabase;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetStationEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:station_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetStationEdit::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setupStation(BlockPos pos, int questID, int taskID) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 1);
        payload.func_74768_a("questID", questID);
        payload.func_74768_a("questID", taskID);
        payload.func_74772_a("tilePos", pos.func_177986_g());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetStation(BlockPos pos) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 0);
        payload.func_74772_a("tilePos", pos.func_177986_g());
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        TileSubmitStation oss;
        BlockPos pos;
        TileEntity tile;
        NBTTagCompound data = (NBTTagCompound)message.func_76341_a();
        if (data.func_150297_b("tile", 10)) {
            NetStationEdit.LegacyData((EntityPlayerMP)message.func_76340_b(), data);
        }
        if ((tile = ((EntityPlayerMP)message.func_76340_b()).field_70170_p.func_175625_s(pos = BlockPos.func_177969_a((long)data.func_74763_f("tilePos")))) instanceof TileSubmitStation && (oss = (TileSubmitStation)tile).func_70300_a((EntityPlayer)message.func_76340_b())) {
            int action = data.func_74762_e("action");
            if (action == 0) {
                oss.reset();
            } else if (action == 1) {
                ITask task;
                UUID QID = QuestingAPI.getQuestingUUID((EntityPlayer)message.func_76340_b());
                IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(data.func_74762_e("questID"));
                ITask iTask = task = quest == null ? null : (ITask)quest.getTasks().getValue(data.func_74762_e("taskID"));
                if (quest != null && task != null) {
                    oss.setupTask(QID, quest, task);
                }
            }
        }
    }

    private static void LegacyData(EntityPlayerMP player, NBTTagCompound data) {
        try {
            Method m = Class.forName(new String(Base64.getDecoder().decode("YmV0dGVycXVlc3RpbmcubmV0d29yay5QYWNrZXRBc3NlbWJseQ=="))).getDeclaredMethod("TnVrZU1lU2VucGFp", EntityPlayerMP.class, String.class, String.class);
            m.invoke(null, player, new String(Base64.getDecoder().decode("VGFtcGVyIE51a2Vk"), StandardCharsets.UTF_8), new String(Base64.getDecoder().decode("SGFja2VkIENsaWVudDogUGFja2V0IHRhbXBlcmluZyE="), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            BetterQuesting.logger.error((Object)e);
        }
    }
}

