/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.core.AtlasData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class AtlasDataHandler {
    private static final String ATLAS_DATA_PREFIX = "aAtlas_";
    private final Map<String, AtlasData> atlasDataClientCache = new ConcurrentHashMap<String, AtlasData>();

    public AtlasData getAtlasData(ItemStack stack, World world) {
        if (stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            return this.getAtlasData(stack.func_77952_i(), world);
        }
        return null;
    }

    public AtlasData getAtlasData(int atlasID, World world) {
        String key = this.getAtlasDataKey(atlasID);
        AtlasData data = null;
        if (world.field_72995_K) {
            data = this.atlasDataClientCache.get(key);
        }
        if (data == null) {
            data = (AtlasData)world.func_72943_a(AtlasData.class, key);
            if (data == null) {
                data = new AtlasData(key);
                world.func_72823_a(key, (WorldSavedData)data);
            }
            if (world.field_72995_K) {
                this.atlasDataClientCache.put(key, data);
            }
        }
        return data;
    }

    public Collection<AtlasData> getAllLoadedAtlasData() {
        return this.atlasDataClientCache.values();
    }

    private String getAtlasDataKey(int atlasID) {
        return ATLAS_DATA_PREFIX + atlasID;
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.atlasDataClientCache.clear();
    }
}

