/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class BiomeDetectorEnd
extends BiomeDetectorBase
implements IBiomeDetector {
    @Override
    public int getBiomeID(Chunk chunk) {
        int[] chunkBiomes;
        int biomesCount = Biome.field_185377_q.func_148742_b().size();
        try {
            chunkBiomes = ByteUtil.unsignedByteToIntArray(biomeArrayMethod.invoke((Object)chunk, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        int[] biomeOccurrences = new int[biomesCount];
        int islandOccurences = 0;
        int plantOccurences = 0;
        int voidOccurences = 0;
        int endID = Biome.func_185362_a((Biome)Biomes.field_76779_k);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeID = chunkBiomes[x << 4 | z];
                if (biomeID == endID) {
                    int top = chunk.func_76611_b(x, z);
                    Block topBlock = chunk.func_186032_a(x, top - 1, z).func_177230_c();
                    if (topBlock == Blocks.field_150377_bs) {
                        ++islandOccurences;
                        Block rootBlock = chunk.func_186032_a(x, top, z).func_177230_c();
                        if (rootBlock == Blocks.field_185766_cS || rootBlock == Blocks.field_185765_cR) {
                            ++plantOccurences;
                        }
                    }
                    if (topBlock != Blocks.field_150350_a) continue;
                    ++voidOccurences;
                    continue;
                }
                if (biomeID < 0 || biomeID >= biomesCount || Biome.func_185357_a((int)biomeID) == null) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + this.priorityForBiome(Biome.func_185357_a((int)biomeID));
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        if (meanBiomeOccurences < islandOccurences) {
            meanBiomeId = plantOccurences == 0 ? ExtTileIdMap.instance().getPseudoBiomeID("endIsland") : ExtTileIdMap.instance().getPseudoBiomeID("endIslandPlants");
        } else if (meanBiomeOccurences < voidOccurences) {
            meanBiomeId = ExtTileIdMap.instance().getPseudoBiomeID("endVoid");
        }
        return meanBiomeId;
    }
}

