/*
 * Decompiled with CFR 0.152.
 */
package bq_npc_integration.rewards;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_npc_integration.client.gui.rewards.PanelRewardFaction;
import bq_npc_integration.rewards.factory.FactoryRewardFaction;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class RewardNpcFaction
implements IReward {
    public int factionID = 0;
    public int value = 10;
    public boolean relative = false;

    public ResourceLocation getFactoryID() {
        return FactoryRewardFaction.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_npc_integration.reward.faction";
    }

    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        return true;
    }

    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        if (player.func_184102_h() == null) {
            return;
        }
        PlayerData pData = PlayerDataController.instance.getDataFromUsername(player.func_184102_h(), player.func_146103_bH().getName());
        if (pData == null || !pData.factionData.factionData.containsKey(this.factionID)) {
            return;
        }
        if (this.relative) {
            pData.factionData.increasePoints(player, this.factionID, this.value);
        } else {
            pData.factionData.factionData.put(this.factionID, this.value);
        }
    }

    public void readFromNBT(NBTTagCompound json) {
        this.factionID = !json.func_150297_b("factionID", 99) ? 0 : json.func_74762_e("factionID");
        this.value = !json.func_150297_b("value", 99) ? 1 : json.func_74762_e("value");
        this.relative = !json.func_74764_b("relative") || json.func_74767_n("relative");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74768_a("factionID", this.factionID);
        json.func_74768_a("value", this.value);
        json.func_74757_a("relative", this.relative);
        return json;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardFaction(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getRewardEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }
}

