/*
 * Decompiled with CFR 0.152.
 */
package bq_npc_integration.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_npc_integration.client.gui.tasks.PanelTaskFaction;
import bq_npc_integration.core.BQ_NPCs;
import bq_npc_integration.tasks.ITaskTickable;
import bq_npc_integration.tasks.factory.FactoryTaskFaction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;
import org.apache.logging.log4j.Level;

public class TaskNpcFaction
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, Integer> userProgress = new HashMap();
    public int factionID = 0;
    public int target = 10;
    public PointOperation operation = PointOperation.MORE_OR_EQUAL;

    public ResourceLocation getFactoryID() {
        return FactoryTaskFaction.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_npc_integration.task.faction";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Override
    public void tickTask(DBEntry<IQuest> quest, ParticipantInfo pInfo) {
        if (pInfo.PLAYER.field_70173_aa % 60 != 0 || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue() || pInfo.PLAYER.func_184102_h() == null) {
            return;
        }
        this.detect(pInfo, quest);
        PlayerData pData = PlayerDataController.instance.getDataFromUsername(pInfo.PLAYER.func_184102_h(), pInfo.PLAYER.func_146103_bH().getName());
        if (pData == null || !pData.factionData.factionData.containsKey(this.factionID)) {
            return;
        }
        int cur = pData.factionData.getFactionPoints(pInfo.PLAYER, this.factionID);
        if (this.getUsersProgress(pInfo.UUID) != cur) {
            this.setUserProgress(pInfo.UUID, pData.factionData.getFactionPoints(pInfo.PLAYER, this.factionID));
        }
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (this.isComplete(pInfo.UUID) || pInfo.PLAYER.func_184102_h() == null) {
            return;
        }
        PlayerData pData = PlayerDataController.instance.getDataFromUsername(pInfo.PLAYER.func_184102_h(), pInfo.PLAYER.func_146103_bH().getName());
        if (pData == null || !pData.factionData.factionData.containsKey(this.factionID)) {
            return;
        }
        int points = pData.factionData.getFactionPoints(pInfo.PLAYER, this.factionID);
        boolean flag = this.operation.checkValues(points, this.target);
        if (flag) {
            this.setComplete(pInfo.UUID);
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    public void readFromNBT(NBTTagCompound json) {
        this.factionID = !json.func_150297_b("factionID", 99) ? 0 : json.func_74762_e("factionID");
        this.target = !json.func_150297_b("target", 99) ? 1 : json.func_74762_e("target");
        this.operation = PointOperation.valueOf(!json.func_150297_b("operation", 8) ? "MORE_OR_EQUAL" : json.func_74779_i("operation"));
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_NPCs.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74762_e("value"));
                continue;
            }
            catch (Exception e) {
                BQ_NPCs.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74768_a("factionID", this.factionID);
        json.func_74768_a("target", this.target);
        json.func_74778_a("operation", this.operation.name());
        return json;
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Integer data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74768_a("value", data.intValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74768_a("value", data.intValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskFaction(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }

    private void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public Integer getUsersProgress(UUID ... users) {
        int i = 0;
        for (UUID uuid : users) {
            Integer n = this.userProgress.get(uuid);
            i += n == null ? 0 : n;
        }
        return i;
    }

    public static enum PointOperation {
        EQUAL("="),
        LESS_THAN("<"),
        MORE_THAN(">"),
        LESS_OR_EQUAL("<="),
        MORE_OR_EQUAL(">="),
        NOT("=/=");

        final String text;

        private PointOperation(String text) {
            this.text = text;
        }

        public String GetText() {
            return this.text;
        }

        public boolean checkValues(int n1, int n2) {
            switch (this) {
                case EQUAL: {
                    return n1 == n2;
                }
                case LESS_THAN: {
                    return n1 < n2;
                }
                case MORE_THAN: {
                    return n1 > n2;
                }
                case LESS_OR_EQUAL: {
                    return n1 <= n2;
                }
                case MORE_OR_EQUAL: {
                    return n1 >= n2;
                }
                case NOT: {
                    return n1 != n2;
                }
            }
            return false;
        }
    }
}

