/*
 * Decompiled with CFR 0.152.
 */
package bq_npc_integration.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_npc_integration.client.gui.tasks.PanelTaskQuest;
import bq_npc_integration.core.BQ_NPCs;
import bq_npc_integration.tasks.ITaskTickable;
import bq_npc_integration.tasks.factory.FactoryTaskQuest;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerQuestController;
import org.apache.logging.log4j.Level;

public class TaskNpcQuest
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public int npcQuestID = -1;

    public ResourceLocation getFactoryID() {
        return FactoryTaskQuest.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_npc_integration.task.quest";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public void tickTask(DBEntry<IQuest> quest, ParticipantInfo pInfo) {
        if (pInfo.PLAYER.field_70173_aa % 60 != 0 || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return;
        }
        this.detect(pInfo, quest);
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        if (PlayerQuestController.isQuestFinished((EntityPlayer)pInfo.PLAYER, (int)this.npcQuestID)) {
            this.setComplete(pInfo.UUID);
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskQuest(rect, this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74768_a("npcQuestID", this.npcQuestID);
        return json;
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.npcQuestID = !json.func_150297_b("npcQuestID", 99) ? -1 : json.func_74762_e("npcQuestID");
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_NPCs.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return null;
    }
}

