/*
 * Decompiled with CFR 0.152.
 */
package stal111.ci.objects.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stal111.ci.Main;
import stal111.ci.init.ModBlocks;

public class BlockSack
extends BlockFalling {
    private static final AxisAlignedBB BAG_1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.562, 1.0);
    private static final AxisAlignedBB BAG_2 = new AxisAlignedBB(0.062, 0.562, 0.062, 0.938, 0.625, 0.938);
    private static final AxisAlignedBB BAG_3 = new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 0.812, 1.0);
    private static final AxisAlignedBB COMPRESSED_1 = new AxisAlignedBB(0.062, 0.812, 0.062, 0.938, 0.938, 0.938);
    private static final AxisAlignedBB COMPRESSED_2 = new AxisAlignedBB(0.188, 0.938, 0.188, 0.812, 1.0, 0.812);
    private static final List<AxisAlignedBB> COLLISION_BOXES = Lists.newArrayList((Object[])new AxisAlignedBB[]{BAG_1, BAG_2, BAG_3, COMPRESSED_1, COMPRESSED_2});
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockSack(String name) {
        super(Material.field_151580_n);
        this.setRegistryName(name);
        this.func_149663_c("ci." + name);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149647_a(Main.ci);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (world.func_180495_p(pos).func_177230_c().equals(ModBlocks.gunpowder_sack)) {
            for (int i = 0; i < 1; ++i) {
                double d0 = (double)((float)pos.func_177958_n() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.5;
                double d1 = (double)((float)pos.func_177956_o() + 0.7f) + (double)(random.nextFloat() - 0.5f) * 0.5 + 0.5;
                double d2 = (double)((float)pos.func_177952_p() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.5;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1 + (double)0.22f, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        entityBox = entityBox.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        for (AxisAlignedBB box : COLLISION_BOXES) {
            if (!entityBox.func_72326_a(box)) continue;
            collidingBoxes.add(box.func_186670_a(pos));
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        double distanceSqShortest = Double.POSITIVE_INFINITY;
        RayTraceResult resultClosest = null;
        start = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        end = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (AxisAlignedBB box : COLLISION_BOXES) {
            double distanceSq;
            RayTraceResult result = box.func_72327_a(start, end);
            if (result == null || !((distanceSq = result.field_72307_f.func_72436_e(start)) < distanceSqShortest)) continue;
            distanceSqShortest = distanceSq;
            resultClosest = result;
        }
        return resultClosest == null ? null : new RayTraceResult(RayTraceResult.Type.BLOCK, resultClosest.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), resultClosest.field_178784_b, pos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

