/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMItems;
import betterwithmods.util.FluidUtils;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDynamite
extends Entity
implements IProjectile {
    private static final float pi = 3.141593f;
    private int fuse = -1;

    public EntityDynamite(World world) {
        this(world, 0.0, 0.0, 0.0);
    }

    public EntityDynamite(World world, double xPos, double yPos, double zPos) {
        super(world);
        this.func_70105_a(0.25f, 0.4f);
        this.func_70107_b(xPos, yPos, zPos);
        this.fuse = 0;
        this.field_70156_m = true;
        this.field_70178_ae = true;
    }

    public EntityDynamite(World world, EntityLivingBase owner, boolean lit) {
        this(world);
        this.func_70012_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * 0.4f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.75f, 1.0f);
        this.fuse = lit ? 100 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 100) {
            this.fuse = 100;
        }
    }

    public void func_70071_h_() {
        Fluid fluid = FluidUtils.getFluidFromBlock(this.field_70170_p, this.func_180425_c(), EnumFacing.UP);
        if (fluid != null && fluid.getTemperature() >= FluidRegistry.LAVA.getTemperature()) {
            this.fuse = 1;
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() == Blocks.field_150480_ab) {
            this.fuse = 1;
            this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (this.fuse > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)100);
                if (this.fuse % 20 == 0) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187904_gd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            float smokeOffset = 0.25f;
            if (fluid != null && fluid == FluidRegistry.WATER) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            } else {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * (double)smokeOffset, this.field_70163_u - this.field_70181_x * (double)smokeOffset, this.field_70161_v - this.field_70179_y * (double)smokeOffset, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            --this.fuse;
            if (this.fuse <= 0) {
                if (!this.func_130014_f_().field_72995_K) {
                    this.explode();
                }
                this.func_70106_y();
            }
        } else if (this.field_70122_E && Math.abs(this.field_70159_w) < 0.01 && Math.abs(this.field_70181_x) < 0.01 && Math.abs(this.field_70179_y) < 0.01) {
            this.convertToItem();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.7;
            this.field_70179_y *= 0.7;
            this.field_70181_x *= -0.5;
        }
        this.func_70066_B();
    }

    public void func_70186_c(double dX, double dY, double dZ, float angle, float f) {
        float sqrt = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
        dX /= (double)sqrt;
        dY /= (double)sqrt;
        dZ /= (double)sqrt;
        dX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        dZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)f;
        this.field_70159_w = dX *= (double)angle;
        this.field_70181_x = dY *= (double)angle;
        this.field_70179_y = dZ *= (double)angle;
        float pitch = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(dX, dZ) * 180.0 / (double)3.141593f);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(dY, pitch) * 180.0 / (double)3.141593f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b("Fuse")) {
            this.fuse = tag.func_74762_e("Fuse");
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound tag) {
        if (this.fuse > 0) {
            tag.func_74768_a("Fuse", this.fuse);
        }
    }

    public void explode() {
        float intensity = 1.5f;
        this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, intensity, true);
        this.redneckFishing(this.func_180425_c());
    }

    private void redneckFishing(BlockPos center) {
        if (this.isWaterBlock(center)) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-4, -4, -4), (BlockPos)center.func_177982_a(4, 4, 4))) {
                if (!this.isWaterBlock(pos) || this.field_70146_Z.nextInt(20) != 0) continue;
                this.spawnDeadFish(pos);
            }
        }
    }

    @Deprecated
    private boolean isWaterBlock(BlockPos pos) {
        Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
        return block instanceof BlockLiquid && this.func_130014_f_().func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    private void spawnDeadFish(BlockPos pos) {
        LootContext.Builder build = new LootContext.Builder((WorldServer)this.field_70170_p);
        List fish = this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186390_ao).func_186462_a(this.field_70170_p.field_73012_v, build.func_186471_a());
        for (ItemStack stack : fish) {
            InvUtils.spawnStack(this.field_70170_p, pos, Lists.newArrayList((Object[])new ItemStack[]{stack}));
        }
    }

    private void convertToItem() {
        if (!this.field_70170_p.field_72995_K) {
            InvUtils.spawnStack(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20, new ItemStack(BWMItems.DYNAMITE));
        }
        this.func_70106_y();
    }
}

