/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.beacons;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockBeacon;
import betterwithmods.common.blocks.BlockEnderchest;
import betterwithmods.common.blocks.tile.TileEnderchest;
import betterwithmods.common.items.tools.ItemSoulforgeArmor;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.IngredientSpecial;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.beacons.BeaconEffect;
import betterwithmods.module.hardcore.beacons.CapabilityBeacon;
import betterwithmods.module.hardcore.beacons.CosmeticBeaconEffect;
import betterwithmods.module.hardcore.beacons.EnderBeaconEffect;
import betterwithmods.module.hardcore.beacons.EnderchestCap;
import betterwithmods.module.hardcore.beacons.HellfireBeaconEffect;
import betterwithmods.module.hardcore.beacons.PotionBeaconEffect;
import betterwithmods.module.hardcore.beacons.SpawnBeaconEffect;
import betterwithmods.util.ReflectionLib;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCBeacons
extends Feature {
    public static final List<BeaconEffect> BEACON_EFFECTS = Lists.newArrayList();
    public static ResourceLocation WORLD1 = new ResourceLocation("betterwithmods", "world_enderchest");
    public static ResourceLocation WORLD2 = new ResourceLocation("betterwithmods", "world2_enderchest");
    public static ResourceLocation GLOBAL = new ResourceLocation("betterwithmods", "global_enderchest");
    private static boolean enderchestBeacon;
    private static boolean enableBeaconCustomization;
    private Block BEACON = (Block)new BlockBeacon().setRegistryName("minecraft:beacon");
    private Block ENDER_CHEST = (Block)new BlockEnderchest().setRegistryName("minecraft:ender_chest");

    public static BeaconEffect getEffect(World world, BlockPos pos, IBlockState blockState) {
        for (BeaconEffect beaconEffect : BEACON_EFFECTS) {
            if (!beaconEffect.isBlockStateValid(world, pos, blockState)) continue;
            return beaconEffect;
        }
        return null;
    }

    public static boolean isValidBeaconBase(IBlockState blockState) {
        return HCBeacons.getEffect(null, null, blockState) != null;
    }

    @Override
    public void setupConfig() {
        enableBeaconCustomization = this.loadPropBool("Enable Beacon Customization", "Allows you to customize parts of beacons, and disable specific ones. Requires restart to generate additional configs", false);
        enderchestBeacon = this.loadPropBool("Enderchest Beacon", "Rework how Enderchests work. Enderchests on their own work like normal chests. When placed on a beacon made of Ender Block the chest functions depending on level, more info in the Book of Single.", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        BWMBlocks.registerBlock(this.BEACON);
        ReflectionLib.reflectSubalias(this.BEACON, "BEACON", "field_150461_bJ");
        if (enderchestBeacon) {
            BWMBlocks.registerBlock(this.ENDER_CHEST);
            ReflectionLib.reflectSubalias(this.ENDER_CHEST, "ENDER_CHEST", "field_150477_bB");
            CapabilityManager.INSTANCE.register(EnderchestCap.class, (Capability.IStorage)new EnderchestCap.Storage(), EnderchestCap::new);
        }
        CapabilityManager.INSTANCE.register(CapabilityBeacon.class, (Capability.IStorage)new CapabilityBeacon.Storage(), CapabilityBeacon::new);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BEACON_EFFECTS.add(new CosmeticBeaconEffect("glass", new BlockDropIngredient("blockGlass")));
        BEACON_EFFECTS.add(new CosmeticBeaconEffect("wool", new BlockDropIngredient("wool")));
        BEACON_EFFECTS.add(new CosmeticBeaconEffect("terracotta", new BlockDropIngredient("terracotta")));
        BEACON_EFFECTS.add(new CosmeticBeaconEffect("concrete", new BlockDropIngredient("concrete")));
        BEACON_EFFECTS.add(new PotionBeaconEffect("iron", new BlockIngredient("blockIron"), EntityMob.class).addPotionEffect(MobEffects.field_188423_x, 25000, PotionBeaconEffect.Amplification.ZERO).setBaseBeamColor(Color.WHITE).setTickRate(3600));
        BEACON_EFFECTS.add(new PotionBeaconEffect("emerald", new BlockIngredient("blockEmerald"), EntityLivingBase.class).addPotionEffect(BWRegistry.POTION_LOOTING, 125, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.GREEN));
        BEACON_EFFECTS.add(new PotionBeaconEffect("lapis", new BlockIngredient("blockLapis"), EntityPlayer.class).addPotionEffect(BWRegistry.POTION_TRUESIGHT, 125, PotionBeaconEffect.Amplification.NONE).setBaseBeamColor(Color.BLUE));
        BEACON_EFFECTS.add(new PotionBeaconEffect("diamond", new BlockIngredient("blockDiamond"), EntityPlayer.class).addPotionEffect(BWRegistry.POTION_FORTUNE, 125, PotionBeaconEffect.Amplification.LEVEL_REDUCED).setBaseBeamColor(Color.CYAN));
        BEACON_EFFECTS.add(new PotionBeaconEffect("glowstone", new BlockIngredient("glowstone"), EntityPlayer.class).addPotionEffect(MobEffects.field_76439_r, 400, PotionBeaconEffect.Amplification.LEVEL_REDUCED).setBaseBeamColor(Color.YELLOW));
        BEACON_EFFECTS.add(new PotionBeaconEffect("gold", new BlockIngredient("blockGold"), EntityPlayer.class).addPotionEffect(MobEffects.field_76422_e, 120, PotionBeaconEffect.Amplification.LEVEL_REDUCED).setBaseBeamColor(Color.YELLOW));
        BEACON_EFFECTS.add(new PotionBeaconEffect("slime", new BlockIngredient("blockSlime"), EntityPlayer.class).addPotionEffect(MobEffects.field_76430_j, 120, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.GREEN));
        BEACON_EFFECTS.add(new PotionBeaconEffect("dung", new BlockIngredient("blockDung"), EntityPlayer.class).setCanApply(entityPlayer -> !PlayerHelper.hasFullSet((EntityPlayer)entityPlayer, ItemSoulforgeArmor.class)).addPotionEffect(MobEffects.field_76436_u, 120, PotionBeaconEffect.Amplification.LEVEL).addPotionEffect(MobEffects.field_76431_k, 120, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.BLACK));
        BEACON_EFFECTS.add(new PotionBeaconEffect("coal", new BlockIngredient("blockCoal"), EntityPlayer.class).setCanApply(entityPlayer -> !PlayerHelper.hasPart(entityPlayer, EntityEquipmentSlot.HEAD, ItemSoulforgeArmor.class)).addPotionEffect(MobEffects.field_76440_q, 120, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.BLACK));
        BEACON_EFFECTS.add(new HellfireBeaconEffect());
        BEACON_EFFECTS.add(new PotionBeaconEffect("prismarine", new BlockIngredient("blockPrismarine"), EntityPlayer.class).addPotionEffect(MobEffects.field_76427_o, 120, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.BLUE));
        BEACON_EFFECTS.add(new PotionBeaconEffect("padding", new BlockIngredient("blockPadding"), EntityPlayer.class).addPotionEffect(BWRegistry.POTION_SLOWFALL, 120, PotionBeaconEffect.Amplification.LEVEL).setBaseBeamColor(Color.PINK));
        BEACON_EFFECTS.add(new SpawnBeaconEffect());
        if (enderchestBeacon) {
            BEACON_EFFECTS.add(new EnderBeaconEffect());
        }
        BEACON_EFFECTS.add(new CosmeticBeaconEffect("compatibility", new BlockIngredient(new IngredientSpecial(stack -> {
            try {
                return stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d().isBeaconBase(null, null, null);
            }
            catch (NullPointerException e) {
                return false;
            }
        }))));
        if (enableBeaconCustomization) {
            for (BeaconEffect beaconEffect : BEACON_EFFECTS) {
                String categoryName = String.join((CharSequence)".", this.configCategory, beaconEffect.getResourceLocation().func_110623_a());
                beaconEffect.setupConfig(categoryName);
            }
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Overhauls the function of Beacons. Beacons have extended range, no longer have a GUI, and require the same material throughout the pyramid. The pyramid material determines the beacon effect, and additional tiers increase the range and strength of the effects. Some beacon types may also cause side effects to occur while a beacon is active.";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void attachTileCapability(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEnderchest && !((TileEntity)event.getObject()).hasCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.UP)) {
            event.addCapability(new ResourceLocation("betterwithmods", "enderchest"), (ICapabilityProvider)new EnderchestCap(EnumFacing.UP));
        }
    }

    @SubscribeEvent
    public void attachWorldCapability(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (!world.hasCapability(CapabilityBeacon.BEACON_CAPABILITY, EnumFacing.UP)) {
            event.addCapability(new ResourceLocation("betterwithmods", "beacons"), (ICapabilityProvider)new CapabilityBeacon());
        }
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && !world.hasCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.DOWN)) {
            event.addCapability(GLOBAL, (ICapabilityProvider)new EnderchestCap(EnumFacing.DOWN));
        }
        if (!world.hasCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.SOUTH)) {
            event.addCapability(WORLD1, (ICapabilityProvider)new EnderchestCap(EnumFacing.SOUTH));
        }
        if (!world.hasCapability(EnderchestCap.ENDERCHEST_CAPABILITY, EnumFacing.NORTH)) {
            event.addCapability(WORLD2, (ICapabilityProvider)new EnderchestCap(EnumFacing.NORTH));
        }
    }
}

