/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting;

import betterwithmods.api.util.IWood;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.registry.BrokenToolRegistry;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCLumber
extends Feature {
    public static int plankAmount;
    public static int barkAmount;
    public static int sawDustAmount;
    public static int axePlankAmount;
    public static int axeBarkAmount;
    public static int axeSawDustAmount;

    public static boolean hasAxe(EntityPlayer harvester, BlockPos pos, IBlockState state) {
        if (harvester == null) {
            return false;
        }
        return PlayerHelper.isCurrentToolEffectiveOnBlock(harvester, pos, state);
    }

    @Override
    public void setupConfig() {
        plankAmount = this.loadPropInt("Plank Amount", "Amount of Planks dropped when Punching Wood", 2);
        barkAmount = this.loadPropInt("Bark Amount", "Amount of Bark dropped when Punching Wood", 1);
        sawDustAmount = this.loadPropInt("Sawdust Amount", "Amount of Sawdust dropped when Punching Wood", 2);
        axePlankAmount = this.loadPropInt("Axe Plank Amount", "Amount of Planks dropped when crafted with an axe", 3);
        axeBarkAmount = this.loadPropInt("Axe Bark Amount", "Amount of Bark dropped when crafted with an axe", 1);
        axeSawDustAmount = this.loadPropInt("Axe Sawdust Amount", "Amount of Sawdust dropped when crafted with an axe", 2);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes Punching Wood return a single plank and secondary drops instead of a log, to get a log an axe must be used.";
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BrokenToolRegistry.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        for (IRecipe recipe : BWOreDictionary.logRecipes) {
            BWMRecipes.removeRecipe(recipe);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void harvestLog(BlockEvent.HarvestDropsEvent event) {
        IWood wood;
        if (!event.getWorld().field_72995_K && (wood = BWOreDictionary.getWoodFromState(event.getState())) != null) {
            if (event.isSilkTouching() || HCLumber.hasAxe(event.getHarvester(), event.getPos(), event.getState())) {
                return;
            }
            event.setDropChance(1.0f);
            event.getDrops().clear();
            event.getDrops().addAll(Lists.newArrayList((Object[])new ItemStack[]{wood.getPlank(plankAmount), wood.getSawdust(sawDustAmount), wood.getBark(barkAmount)}));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        axePlankAmount = 4;
        axeBarkAmount = 1;
        axeSawDustAmount = 2;
    }
}

