/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.components;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class Component {
    public int getPadding() {
        return 1;
    }

    public int getHeight() {
        return this.getHeightInternal() + this.getPadding() * 2;
    }

    public int getWidth() {
        return this.getWidthInternal() + this.getPadding() * 2;
    }

    public void render(int x, int y) {
        this.renderInternal(x + this.getPadding(), y + this.getPadding());
    }

    public boolean shouldRender() {
        return true;
    }

    public abstract int getHeightInternal();

    public abstract int getWidthInternal();

    public abstract void renderInternal(int var1, int var2);

    protected void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        this.drawTexturedModalRect(x, y, textureX, textureY, width, height, 256.0, 256.0);
    }

    protected void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, double textureWidth, double textureHeight) {
        double minU = (double)textureX / textureWidth;
        double maxU = (double)(textureX + width) / textureWidth;
        double minV = (double)textureY / textureHeight;
        double maxV = (double)(textureY + height) / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(minU, maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(maxU, maxV).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(maxU, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

