/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackCountPane;
import xreliquary.reference.Colors;
import xreliquary.util.InventoryHelper;

@ParametersAreNonnullByDefault
public class ChargePane
extends Component {
    private Item mainItem;
    private ItemStackCountPane chargeablePane;
    private Function<ItemStack, Integer> getCount;

    public ChargePane(Item mainItem, ItemStack chargeItem, Function<ItemStack, Integer> getCount) {
        this(mainItem, chargeItem, getCount, Colors.get("FFFFFF"));
    }

    public ChargePane(Item mainItem, ItemStack chargeItem, Function<ItemStack, Integer> getCount, int textColor) {
        this.mainItem = mainItem;
        this.getCount = getCount;
        this.chargeablePane = new ItemStackCountPane(chargeItem, 0, textColor);
    }

    @Override
    public int getHeightInternal() {
        return this.chargeablePane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.chargeablePane.getWidth();
    }

    @Override
    public int getPadding() {
        return this.chargeablePane.getPadding();
    }

    @Override
    public void renderInternal(int x, int y) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = InventoryHelper.getCorrectItemFromEitherHand((EntityPlayer)player, this.mainItem);
        if (itemStack.func_190926_b()) {
            return;
        }
        this.chargeablePane.setCount(this.getCount.apply(itemStack));
        this.chargeablePane.render(x, y);
    }
}

