/*
 * Decompiled with CFR 0.152.
 */
package magmasrc.ageofweapons.tileentitys;

import javax.annotation.Nullable;
import magmasrc.ageofweapons.blocks.BlockCrusher;
import magmasrc.ageofweapons.containers.ContainerCrusher;
import magmasrc.ageofweapons.crushing.CrusherRecipes;
import magmasrc.ageofweapons.main.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityCrusher
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> crusherItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int crusherBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String crusherCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.crusherItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.crusherItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.crusherItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.crusherItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.crusherItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.crusherItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.crusherItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.crusherCustomName : ModBlocks.crusher.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.crusherCustomName != null && !this.crusherCustomName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.crusherCustomName = p_145951_1_;
    }

    public static void registerFixescrusher(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(TileEntityCrusher.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.crusherItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.crusherItemStacks);
        this.crusherBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityCrusher.getItemBurnTime((ItemStack)this.crusherItemStacks.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.crusherCustomName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.crusherBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.crusherItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.crusherCustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.crusherBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.crusherBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.crusherItemStacks.get(1);
            if (this.isBurning() || !itemstack.func_190926_b() && !((ItemStack)this.crusherItemStacks.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.crusherBurnTime = TileEntityCrusher.getItemBurnTime(itemstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.crusherItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.crusherItemStacks.get(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockCrusher.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.crusherItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = CrusherRecipes.instance().getCrushingResult((ItemStack)this.crusherItemStacks.get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.crusherItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        int result = itemstack1.func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.crusherItemStacks.get(0);
            ItemStack itemstack1 = CrusherRecipes.instance().getCrushingResult(itemstack);
            ItemStack itemstack2 = (ItemStack)this.crusherItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.crusherItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstack.func_77960_j() == 1 && !((ItemStack)this.crusherItemStacks.get(1)).func_190926_b() && ((ItemStack)this.crusherItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.crusherItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            itemstack.func_190918_g(1);
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityCrusher.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.crusherItemStacks.get(1);
        return TileEntityCrusher.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "ageofweapons:crusher";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCrusher(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.crusherBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.crusherBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.crusherItemStacks.clear();
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }
}

