/*
 * Decompiled with CFR 0.152.
 */
package magmasrc.ageofweapons.worldgen;

import com.google.common.base.Predicate;
import java.util.Random;
import magmasrc.ageofweapons.main.AgeOfWeapons;
import magmasrc.ageofweapons.main.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOre
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                this.GenerateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.GenerateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.GenerateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void addOre(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chance, int minY, int maxY, Predicate<IBlockState> blockToSpawnIn) {
        int diffMinMaxY = maxY - minY;
        for (int x = 0; x < chance; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize, blockToSpawnIn).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    private void addNetherOre(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chance, int minY, int maxY, Predicate<IBlockState> blockToSpawnIn) {
        int diffMinMaxY = maxY - minY;
        for (int x = 0; x < chance; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize, blockToSpawnIn).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    private void addEndOre(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chance, int minY, int maxY, Predicate<IBlockState> blockToSpawnIn) {
        int diffMinMaxY = maxY - minY;
        for (int x = 0; x < chance; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            new WorldGenMinable(block, maxVeinSize, blockToSpawnIn).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    private void GenerateOverworld(World world, Random random, int chunkX, int chunkZ) {
        if (AgeOfWeapons.activateWorldGeneration) {
            this.addOre(ModBlocks.amberOre.func_176223_P(), world, random, chunkX, chunkZ, 16, 16, 3, 1, 1, 16, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            this.addOre(ModBlocks.amethystOre.func_176223_P(), world, random, chunkX, chunkZ, 16, 16, 3, 1, 1, 16, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            this.addOre(ModBlocks.rubyOre.func_176223_P(), world, random, chunkX, chunkZ, 16, 16, 3, 1, 1, 16, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            this.addOre(ModBlocks.sapphireOre.func_176223_P(), world, random, chunkX, chunkZ, 16, 16, 1, 1, 1, 16, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
            this.addOre(ModBlocks.topazOre.func_176223_P(), world, random, chunkX, chunkZ, 16, 16, 3, 1, 1, 16, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        }
    }

    private void GenerateNether(World world, Random random, int chunkX, int chunkZ) {
        if (AgeOfWeapons.activateWorldGeneration) {
            // empty if block
        }
    }

    private void GenerateEnd(World world, Random random, int chunkX, int chunkZ) {
        if (AgeOfWeapons.activateWorldGeneration) {
            // empty if block
        }
    }
}

