/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.FlywheelStorageRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.core.render.BlockStateKeyGenerator;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockFlywheelStorage
extends BlockBaseAutomation
implements IBakeryProvider {
    public BlockFlywheelStorage(String regName) {
        super(Material.field_151576_e, regName);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AutomationProperties.TIER}).add(new IUnlistedProperty[]{AutomationProperties.DYNAMIC, AutomationProperties.IS_CONTROL, AutomationProperties.HEIGHT, AutomationProperties.WIDTH, AutomationProperties.ROTATION}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AutomationProperties.TIER, (Comparable)((Object)TorqueTier.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))).getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return FlywheelStorageRenderer.INSTANCE.handleState((IExtendedBlockState)state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        WorldTools.getTile((IBlockAccess)world, pos, TileFlywheelStorage.class).ifPresent(TileFlywheelStorage::blockPlaced);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Optional<TileFlywheelStorage> te = WorldTools.getTile((IBlockAccess)world, pos, TileFlywheelStorage.class);
        super.func_180663_b(world, pos, state);
        te.ifPresent(TileFlywheelStorage::blockBroken);
    }

    public int func_180651_a(IBlockState state) {
        return ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))).getMeta();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFlywheelStorage();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, 0));
        list.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, 1));
        list.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, 2));
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelLoaderHelper.registerItem(this, FlywheelStorageRenderer.LIGHT_MODEL_LOCATION);
        ModelBakery.registerBlockKeyGenerator((Block)this, (IBlockStateKeyGenerator)new BlockStateKeyGenerator.Builder().addKeyProperties(new IProperty[]{AutomationProperties.TIER}).addKeyProperties(AutomationProperties.DYNAMIC, AutomationProperties.IS_CONTROL, AutomationProperties.WIDTH, AutomationProperties.HEIGHT).addKeyProperties(o -> String.format("%.6f", o), AutomationProperties.ROTATION).build());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                switch ((TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER))) {
                    case LIGHT: {
                        return FlywheelStorageRenderer.LIGHT_MODEL_LOCATION;
                    }
                    case MEDIUM: {
                        return FlywheelStorageRenderer.MEDIUM_MODEL_LOCATION;
                    }
                }
                return FlywheelStorageRenderer.HEAVY_MODEL_LOCATION;
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelStorageRenderer.LIGHT_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelStorageRenderer.INSTANCE.getSprite(TorqueTier.LIGHT);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelStorageRenderer.MEDIUM_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelStorageRenderer.INSTANCE.getSprite(TorqueTier.MEDIUM);
            }
        });
        ModelRegistryHelper.register((ModelResourceLocation)FlywheelStorageRenderer.HEAVY_MODEL_LOCATION, (IBakedModel)new CCBakeryModel(){

            @SideOnly(value=Side.CLIENT)
            public TextureAtlasSprite func_177554_e() {
                return FlywheelStorageRenderer.INSTANCE.getSprite(TorqueTier.HEAVY);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return FlywheelStorageRenderer.INSTANCE;
    }
}

