/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouse;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ContainerWarehouseControl
extends ContainerTileBase<TileWarehouse> {
    public ItemQuantityMap itemMap = new ItemQuantityMap();
    private final ItemQuantityMap cache = new ItemQuantityMap();
    private boolean shouldUpdate = true;
    public int maxStorage = 0;
    public int currentStored = 0;

    public ContainerWarehouseControl(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.addPlayerSlots(142);
        ((TileWarehouse)this.tileEntity).addViewer(this);
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        ((TileWarehouse)this.tileEntity).removeViewer(this);
        super.func_75134_a(par1EntityPlayer);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        Slot slot = this.func_75139_a(slotClickedIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        if ((stack = ((TileWarehouse)this.tileEntity).tryAdd(stack)).func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        return ItemStack.field_190927_a;
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("slotClick")) {
            NBTTagCompound reqTag = tag.func_74775_l("slotClick");
            ItemStack item = ItemStack.field_190927_a;
            if (reqTag.func_74764_b("reqItem")) {
                item = new ItemStack(reqTag.func_74775_l("reqItem"));
            }
            ((TileWarehouse)this.tileEntity).handleSlotClick(this.player, item, reqTag.func_74767_n("isShiftClick"), reqTag.func_74767_n("isRightClick"));
        } else if (tag.func_74764_b("changeList")) {
            this.handleChangeList(tag.func_150295_c("changeList", 10));
        } else {
            if (tag.func_74764_b("maxStorage")) {
                this.maxStorage = tag.func_74762_e("maxStorage");
            }
            if (tag.func_74764_b("sortType")) {
                ((TileWarehouse)this.tileEntity).setSortType(InventoryTools.ComparatorItemStack.SortType.values()[tag.func_74771_c("sortType")]);
            }
            if (tag.func_74764_b("sortOrder")) {
                ((TileWarehouse)this.tileEntity).setSortOrder(InventoryTools.ComparatorItemStack.SortOrder.values()[tag.func_74771_c("sortOrder")]);
            }
        }
        this.currentStored = this.itemMap.getTotalItemCount();
        this.refreshGui();
    }

    public void handleClientRequestSpecific(ItemStack stack, boolean isShiftClick, boolean isRightClick) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!stack.func_190926_b()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.min(stack.func_190916_E(), stack.func_77976_d()));
            tag.func_74782_a("reqItem", (NBTBase)copy.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74757_a("isShiftClick", isShiftClick);
        tag.func_74757_a("isRightClick", isRightClick);
        NBTTagCompound pktTag = new NBTTagCompound();
        pktTag.func_74782_a("slotClick", (NBTBase)tag);
        this.sendDataToServer(pktTag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.shouldUpdate) {
            this.synchItemMaps();
            this.shouldUpdate = false;
        }
        if (this.maxStorage != ((TileWarehouse)this.tileEntity).getMaxStorage()) {
            this.maxStorage = ((TileWarehouse)this.tileEntity).getMaxStorage();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("maxStorage", this.maxStorage);
            tag.func_74774_a("sortOrder", (byte)this.getSortOrder().ordinal());
            tag.func_74774_a("sortType", (byte)this.getSortType().ordinal());
            this.sendDataToClient(tag);
        }
    }

    private void handleChangeList(NBTTagList changeList) {
        for (int i = 0; i < changeList.func_74745_c(); ++i) {
            NBTTagCompound tag = changeList.func_150305_b(i);
            this.itemMap.putEntryFromNBT(tag);
        }
    }

    private void synchItemMaps() {
        int qty;
        this.cache.clear();
        ((TileWarehouse)this.tileEntity).getItems(this.cache);
        ItemQuantityMap warehouseItemMap = this.cache;
        NBTTagList changeList = new NBTTagList();
        for (ItemQuantityMap.ItemHashEntry wrap : this.itemMap.keySet()) {
            qty = this.itemMap.getCount(wrap);
            if (qty == warehouseItemMap.getCount(wrap)) continue;
            qty = warehouseItemMap.getCount(wrap);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(wrap));
            this.itemMap.put(wrap, qty);
        }
        for (ItemQuantityMap.ItemHashEntry entry : warehouseItemMap.keySet()) {
            if (this.itemMap.contains(entry)) continue;
            qty = warehouseItemMap.getCount(entry);
            changeList.func_74742_a((NBTBase)warehouseItemMap.writeEntryToNBT(entry));
            this.itemMap.put(entry, qty);
        }
        if (changeList.func_74745_c() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("changeList", (NBTBase)changeList);
            this.sendDataToClient(tag);
        }
    }

    public void onWarehouseInventoryUpdated() {
        this.shouldUpdate = true;
    }

    public InventoryTools.ComparatorItemStack.SortType getSortType() {
        return ((TileWarehouse)this.tileEntity).getSortType();
    }

    public void setSortType(InventoryTools.ComparatorItemStack.SortType sortType) {
        ((TileWarehouse)this.tileEntity).setSortType(sortType);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("sortType", (byte)sortType.ordinal());
        this.sendDataToServer(tag);
    }

    public InventoryTools.ComparatorItemStack.SortOrder getSortOrder() {
        return ((TileWarehouse)this.tileEntity).getSortOrder();
    }

    public void setSortOrder(InventoryTools.ComparatorItemStack.SortOrder sortOrder) {
        ((TileWarehouse)this.tileEntity).setSortOrder(sortOrder);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("sortOrder", (byte)sortOrder.ordinal());
        this.sendDataToServer(tag);
    }
}

