/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.datafixes;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;

public class ItemMapDataWalker
implements IDataWalker {
    private final Set<ResourceLocation> tileIds = new HashSet<ResourceLocation>();
    private final String[] tagPathElements;

    public ItemMapDataWalker(Class<?>[] tileClasses, String tagPath) {
        for (Class<?> tileClass : tileClasses) {
            this.tileIds.add(TileEntity.func_190559_a(tileClass));
        }
        this.tagPathElements = tagPath.split("/");
    }

    public NBTTagCompound func_188266_a(IDataFixer fixer, NBTTagCompound compound, int version) {
        ResourceLocation id = new ResourceLocation(compound.func_74779_i("id"));
        if (this.tileIds.contains(id)) {
            this.processItemMap(fixer, this.getItemMapNBT(compound), version);
        }
        return compound;
    }

    private void processItemMap(IDataFixer fixer, NBTTagList itemMapNBT, int version) {
        for (int i = 0; i < itemMapNBT.func_74745_c(); ++i) {
            NBTTagCompound entryTag = itemMapNBT.func_150305_b(i);
            entryTag.func_74782_a("item", (NBTBase)fixer.func_188251_a((IFixType)FixTypes.ITEM_INSTANCE, entryTag.func_74775_l("item"), version));
        }
    }

    private NBTTagList getItemMapNBT(NBTTagCompound compound) {
        NBTTagCompound tag = compound;
        for (int i = 0; i < this.tagPathElements.length - 1; ++i) {
            tag = tag.func_74775_l(this.tagPathElements[i]);
        }
        return tag.func_150295_c(this.tagPathElements[this.tagPathElements.length - 1], 10);
    }
}

