/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.automation.AncientWarfareAutomation;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseControl;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouse;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeItemSlots;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class GuiWarehouseControl
extends GuiContainerBase<ContainerWarehouseControl> {
    private CompositeScrolled area;
    private Text input;
    private final InventoryTools.ComparatorItemStack sorter = new InventoryTools.ComparatorItemStack(((ContainerWarehouseControl)((Object)this.getContainer())).getSortType(), ((ContainerWarehouseControl)((Object)this.getContainer())).getSortOrder());
    private Label storedLabel;

    public GuiWarehouseControl(ContainerBase par1Container) {
        super(par1Container, 178, 240);
    }

    @Override
    public void initElements() {
        Button sortChange = new Button(8, 8, 110, 12, "guistrings.automation." + ((ContainerWarehouseControl)((Object)this.getContainer())).getSortType().toString()){

            @Override
            protected void onPressed() {
                ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).setSortType(((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).getSortType().next());
                this.setText("guistrings.automation." + ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).getSortType().toString());
                GuiWarehouseControl.this.refreshGui();
            }
        };
        this.addGuiElement(sortChange);
        Checkbox sortOrderBox = new Checkbox(122, 6, 16, 16, "guistrings.automation.descending"){

            @Override
            public void onToggled() {
                super.onToggled();
                ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).setSortOrder(this.checked() ? InventoryTools.ComparatorItemStack.SortOrder.ASCENDING : InventoryTools.ComparatorItemStack.SortOrder.DESCENDING);
                String name = ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).getSortOrder().name().toLowerCase(Locale.ENGLISH);
                this.label = I18n.func_135052_a((String)("guistrings.automation." + name), (Object[])new Object[0]);
                GuiWarehouseControl.this.refreshGui();
            }
        };
        sortOrderBox.setChecked(((ContainerWarehouseControl)((Object)this.getContainer())).getSortOrder() == InventoryTools.ComparatorItemStack.SortOrder.ASCENDING);
        this.addGuiElement(sortOrderBox);
        this.input = new Text(8, 24, 162, "", this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                if (!oldText.equals(newText)) {
                    GuiWarehouseControl.this.refreshGui();
                }
            }
        };
        Listener l = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (evt.mButton == 1 && widget.isMouseOverElement(evt.mx, evt.my)) {
                    ((Text)widget).setText("");
                    GuiWarehouseControl.this.refreshGui();
                }
                return false;
            }
        };
        this.input.addNewListener(l);
        this.addGuiElement(this.input);
        this.area = new CompositeItemSlots(this, 0, 38, 178, 96, this);
        l = new Listener(8){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (evt.mButton == 0 && widget.isMouseOverElement(evt.mx, evt.my) && !GuiWarehouseControl.this.area.isMouseOverSubElement(evt.mx, evt.my)) {
                    ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).handleClientRequestSpecific(ItemStack.field_190927_a, GuiScreen.func_146272_n(), false);
                }
                return true;
            }
        };
        this.area.addNewListener(l);
        this.addGuiElement(this.area);
        Button b = new Button(8, 220, 40, 12, "guistrings.automation.adjust_bounds"){

            @Override
            protected void onPressed() {
                NetworkHandler.INSTANCE.openGui(GuiWarehouseControl.this.player, 46, ((TileWarehouse)((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).tileEntity).func_174877_v());
            }
        };
        this.addGuiElement(b);
        this.storedLabel = new Label(52, 221, I18n.func_135052_a((String)"guistrings.warehouse.storage", (Object[])new Object[]{((ContainerWarehouseControl)((Object)this.getContainer())).currentStored, ((ContainerWarehouseControl)((Object)this.getContainer())).maxStorage}));
        this.addGuiElement(this.storedLabel);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.addInventoryViewElements();
        this.storedLabel.setText(I18n.func_135052_a((String)"guistrings.warehouse.storage", (Object[])new Object[]{((ContainerWarehouseControl)((Object)this.getContainer())).currentStored, ((ContainerWarehouseControl)((Object)this.getContainer())).maxStorage}));
    }

    private void addInventoryViewElements() {
        NonNullList displayStacks = NonNullList.func_191196_a();
        for (ItemQuantityMap.ItemHashEntry entry : ((ContainerWarehouseControl)((Object)this.getContainer())).itemMap.keySet()) {
            ItemStack stack = entry.getItemStack();
            if (!this.matchesSearch(stack, entry.getNameAndTooltip())) continue;
            stack.func_190920_e(((ContainerWarehouseControl)((Object)this.getContainer())).itemMap.getCount(entry));
            displayStacks.add((Object)stack);
        }
        this.sortItems((NonNullList<ItemStack>)displayStacks);
        int x = 0;
        int y = 0;
        int totalSize = 22;
        for (ItemStack displayStack : displayStacks) {
            if (x >= 9) {
                x = 0;
                ++y;
                totalSize += 18;
            }
            ItemSlot slot = new ItemSlot(4 + x * 18, 4 + y * 18, displayStack, this){

                @Override
                public void onSlotClicked(ItemStack stack, boolean rightClicked) {
                    ((ContainerWarehouseControl)((Object)GuiWarehouseControl.this.getContainer())).handleClientRequestSpecific(this.getStack(), GuiScreen.func_146272_n(), rightClicked);
                }
            };
            this.area.addGuiElement(slot);
            ++x;
        }
        this.area.setAreaSize(totalSize);
    }

    private boolean matchesSearch(ItemStack stack, String nameAndTooltip) {
        String searchInput = this.input.getText().toLowerCase(Locale.ENGLISH);
        if (searchInput.isEmpty()) {
            return true;
        }
        if (searchInput.startsWith("@")) {
            String[] searchStrings = searchInput.split(" ");
            String modName = searchStrings[0].substring(1);
            ResourceLocation registryName = stack.func_77973_b().getRegistryName();
            if (registryName == null || !registryName.func_110624_b().contains(modName)) {
                return false;
            }
            if (searchStrings.length <= 1) {
                return true;
            }
            searchInput = String.join((CharSequence)" ", Arrays.copyOfRange(searchStrings, 1, searchStrings.length));
        }
        return nameAndTooltip.contains(searchInput);
    }

    private void sortItems(NonNullList<ItemStack> items) {
        this.sorter.setSortType(((ContainerWarehouseControl)((Object)this.getContainer())).getSortType());
        this.sorter.setSortOrder(((ContainerWarehouseControl)((Object)this.getContainer())).getSortOrder());
        try {
            items.sort((Comparator)this.sorter);
        }
        catch (IllegalArgumentException ex) {
            AncientWarfareAutomation.LOG.error("Error sorting warehouse items: " + ex.getMessage());
        }
    }
}

