/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.proxy;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.AutomationInputHandler;
import net.shadowmage.ancientwarfare.automation.block.BlockWaterwheelGenerator;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.gui.GuiWarehouseControl;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteAnimalControl;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteAnimalFarm;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteBoundsAdjust;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteCropFarm;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteFishControl;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteFishFarm;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteFruitFarm;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteInventorySideSelection;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteQuarry;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteQuarryBounds;
import net.shadowmage.ancientwarfare.automation.gui.GuiWorksiteTreeFarm;
import net.shadowmage.ancientwarfare.automation.render.AnimatedBlockRenderer;
import net.shadowmage.ancientwarfare.automation.render.AutoCraftingRenderer;
import net.shadowmage.ancientwarfare.automation.render.FlywheelControllerAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.FlywheelControllerRenderer;
import net.shadowmage.ancientwarfare.automation.render.FlywheelStorageAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.FlywheelStorageRenderer;
import net.shadowmage.ancientwarfare.automation.render.HandCrankedGeneratorRenderer;
import net.shadowmage.ancientwarfare.automation.render.StirlingGeneratorRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueDistributorRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueJunctionRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueShaftAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueShaftRenderer;
import net.shadowmage.ancientwarfare.automation.render.TorqueTransportAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.WarehouseStockViewerRenderer;
import net.shadowmage.ancientwarfare.automation.render.WaterwheelGeneratorRenderer;
import net.shadowmage.ancientwarfare.automation.render.WindmillBladeAnimationRenderer;
import net.shadowmage.ancientwarfare.automation.render.WindmillBladeRenderer;
import net.shadowmage.ancientwarfare.automation.render.WindmillGeneratorRenderer;
import net.shadowmage.ancientwarfare.automation.render.WorksiteRenderer;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileDistributor;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelController;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileHandCrankedGenerator;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileStirlingGenerator;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaft;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSidedCell;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileWaterwheelGenerator;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileWindmillController;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileWindmillBlade;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.config.ConfigManager;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.ClientProxyBase;
import net.shadowmage.ancientwarfare.vehicle.gui.GuiVehicleStats;

@SideOnly(value=Side.CLIENT)
public class ClientProxyAutomation
extends ClientProxyBase {
    public ClientProxyAutomation() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void preInit() {
        super.preInit();
        this.registerClientOptions();
        NetworkHandler.registerGui(5, GuiWorksiteInventorySideSelection.class);
        NetworkHandler.registerGui(14, GuiWorksiteAnimalControl.class);
        NetworkHandler.registerGui(16, GuiWorksiteFishControl.class);
        NetworkHandler.registerGui(18, GuiWarehouseControl.class);
        NetworkHandler.registerGui(24, GuiWorksiteQuarry.class);
        NetworkHandler.registerGui(30, GuiWorksiteQuarryBounds.class);
        NetworkHandler.registerGui(25, GuiWorksiteTreeFarm.class);
        NetworkHandler.registerGui(27, GuiWorksiteCropFarm.class);
        NetworkHandler.registerGui(53, GuiWorksiteFruitFarm.class);
        NetworkHandler.registerGui(52, GuiVehicleStats.class);
        NetworkHandler.registerGui(26, GuiWorksiteAnimalFarm.class);
        NetworkHandler.registerGui(29, GuiWorksiteFishFarm.class);
        NetworkHandler.registerGui(46, GuiWorksiteBoundsAdjust.class);
        ClientRegistry.bindTileEntitySpecialRenderer(TileWorksiteBase.class, (TileEntitySpecialRenderer)new WorksiteRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWarehouseBase.class, (TileEntitySpecialRenderer)new WorksiteRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileWarehouseStockViewer.class, (TileEntitySpecialRenderer)new WarehouseStockViewerRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTorqueSidedCell.class, (TileEntitySpecialRenderer)new TorqueTransportAnimationRenderer(TorqueJunctionRenderer.INSTANCE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileDistributor.class, (TileEntitySpecialRenderer)new TorqueTransportAnimationRenderer(TorqueDistributorRenderer.INSTANCE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileTorqueShaft.class, (TileEntitySpecialRenderer)new TorqueShaftAnimationRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFlywheelController.class, (TileEntitySpecialRenderer)new FlywheelControllerAnimationRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileFlywheelStorage.class, (TileEntitySpecialRenderer)new FlywheelStorageAnimationRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStirlingGenerator.class, new TorqueAnimationRenderer(StirlingGeneratorRenderer.INSTANCE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileWaterwheelGenerator.class, (TileEntitySpecialRenderer)new TorqueAnimationRenderer<TileWaterwheelGenerator>((AnimatedBlockRenderer)WaterwheelGeneratorRenderer.INSTANCE){

            @Override
            protected IExtendedBlockState updateAdditionalProperties(IExtendedBlockState state, TileTorqueBase te) {
                if (te instanceof TileWaterwheelGenerator) {
                    return (IExtendedBlockState)state.func_177226_a((IProperty)BlockWaterwheelGenerator.VALID_SETUP, (Comparable)Boolean.valueOf(((TileWaterwheelGenerator)te).validSetup));
                }
                return state;
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileHandCrankedGenerator.class, new TorqueAnimationRenderer(HandCrankedGeneratorRenderer.INSTANCE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindmillController.class, new TorqueAnimationRenderer(WindmillGeneratorRenderer.INSTANCE));
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindmillBlade.class, (TileEntitySpecialRenderer)new WindmillBladeAnimationRenderer());
    }

    @Override
    public void init() {
        super.init();
        AutomationInputHandler.initKeyBindings();
    }

    private void registerClientOptions() {
        ConfigManager.registerConfigCategory((IConfigElement)new AutomationCategory("awconfig.automation_config"));
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre evt) {
        AutoCraftingRenderer.INSTANCE.setSprite(this.registerSprite(evt, "tile_auto_crafting"));
        StirlingGeneratorRenderer.INSTANCE.setSprite(this.registerSprite(evt, "stirling_generator"));
        HandCrankedGeneratorRenderer.INSTANCE.setSprite(this.registerSprite(evt, "hand_cranked_generator"));
        WaterwheelGeneratorRenderer.INSTANCE.setSprite(this.registerSprite(evt, "waterwheel_generator"));
        WindmillGeneratorRenderer.INSTANCE.setSprite(this.registerSprite(evt, "windmill_generator"));
        WindmillBladeRenderer.INSTANCE.setSprite(this.registerSprite(evt, "windmill_blade"));
        WindmillBladeRenderer.INSTANCE.setCubeSprite(this.registerSprite(evt, "windmill_blade_cube"));
        TorqueShaftRenderer.INSTANCE.setSprite(TorqueTier.HEAVY, this.registerSprite(evt, "torque_shaft_heavy"));
        TorqueShaftRenderer.INSTANCE.setSprite(TorqueTier.MEDIUM, this.registerSprite(evt, "torque_shaft_medium"));
        TorqueShaftRenderer.INSTANCE.setSprite(TorqueTier.LIGHT, this.registerSprite(evt, "torque_shaft_light"));
        TorqueJunctionRenderer.INSTANCE.setSprite(TorqueTier.HEAVY, this.registerSprite(evt, "torque_junction_heavy"));
        TorqueJunctionRenderer.INSTANCE.setSprite(TorqueTier.MEDIUM, this.registerSprite(evt, "torque_junction_medium"));
        TorqueJunctionRenderer.INSTANCE.setSprite(TorqueTier.LIGHT, this.registerSprite(evt, "torque_junction_light"));
        TorqueDistributorRenderer.INSTANCE.setSprite(TorqueTier.HEAVY, this.registerSprite(evt, "torque_distributor_heavy"));
        TorqueDistributorRenderer.INSTANCE.setSprite(TorqueTier.MEDIUM, this.registerSprite(evt, "torque_distributor_medium"));
        TorqueDistributorRenderer.INSTANCE.setSprite(TorqueTier.LIGHT, this.registerSprite(evt, "torque_distributor_light"));
        FlywheelControllerRenderer.INSTANCE.setSprite(TorqueTier.HEAVY, this.registerSprite(evt, "flywheel_controller_heavy"));
        FlywheelControllerRenderer.INSTANCE.setSprite(TorqueTier.MEDIUM, this.registerSprite(evt, "flywheel_controller_medium"));
        FlywheelControllerRenderer.INSTANCE.setSprite(TorqueTier.LIGHT, this.registerSprite(evt, "flywheel_controller_light"));
        FlywheelStorageRenderer.INSTANCE.setSprite(false, TorqueTier.HEAVY, this.registerSprite(evt, "flywheel_small_heavy"));
        FlywheelStorageRenderer.INSTANCE.setSprite(false, TorqueTier.MEDIUM, this.registerSprite(evt, "flywheel_small_medium"));
        FlywheelStorageRenderer.INSTANCE.setSprite(false, TorqueTier.LIGHT, this.registerSprite(evt, "flywheel_small_light"));
        FlywheelStorageRenderer.INSTANCE.setSprite(true, TorqueTier.HEAVY, this.registerSprite(evt, "flywheel_large_heavy"));
        FlywheelStorageRenderer.INSTANCE.setSprite(true, TorqueTier.MEDIUM, this.registerSprite(evt, "flywheel_large_medium"));
        FlywheelStorageRenderer.INSTANCE.setSprite(true, TorqueTier.LIGHT, this.registerSprite(evt, "flywheel_large_light"));
    }

    private TextureAtlasSprite registerSprite(TextureStitchEvent.Pre evt, String spriteName) {
        return evt.getMap().func_174942_a(new ResourceLocation("ancientwarfare:model/automation/" + spriteName));
    }

    public static final class AutomationCategory
    extends DummyConfigElement.DummyCategoryElement {
        public static final ConfigElement renderWorkBounds = new ConfigElement(AWAutomationStatics.renderWorkBounds);

        private AutomationCategory(String name) {
            super(name, name, AutomationCategory.getElementList());
        }

        private static List<IConfigElement> getElementList() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            list.add((IConfigElement)renderWorkBounds);
            return list;
        }
    }
}

