/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.automation.init.AWAutomationBlocks;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ChorusFlowerDrop;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ChorusScanner;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.DefaultTreeScanner;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.IBlockExtraDrop;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ISapling;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITreeScanner;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.Sapling;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;

public class TreeFarmRegistry {
    private static final ITreeScanner DEFAULT_TREE_SCANNER = new DefaultTreeScanner(st -> st.func_185904_a() == Material.field_151575_d && st.func_177230_c() != AWAutomationBlocks.TREE_FARM, sl -> sl.func_185904_a() == Material.field_151584_j);
    private static Set<ISapling> saplings = new HashSet<ISapling>();
    private static Set<BlockStateMatcher> soilBlocks = new HashSet<BlockStateMatcher>();
    private static Set<IBlockExtraDrop> extraBlockDrops = new HashSet<IBlockExtraDrop>();
    private static List<ITreeScanner> treeScanners = new ArrayList<ITreeScanner>();
    private static final IBlockExtraDrop EMPTY_EXTRA_DROP;

    private TreeFarmRegistry() {
    }

    private static void registerTreeScanner(ITreeScanner treeScanner) {
        treeScanners.add(0, treeScanner);
    }

    public static ITreeScanner getTreeScanner(IBlockState state) {
        return TreeFarmRegistry.getRegisteredTreeScanner(state).orElse(DEFAULT_TREE_SCANNER);
    }

    public static Optional<ITreeScanner> getRegisteredTreeScanner(IBlockState state) {
        return treeScanners.stream().filter(ts -> ts.matches(state)).findFirst();
    }

    public static Optional<ISapling> getSapling(ItemStack stack) {
        return saplings.stream().filter(s -> s.matches(stack)).findFirst();
    }

    public static boolean isPlantable(ItemStack stack) {
        return saplings.stream().anyMatch(s -> s.matches(stack));
    }

    public static boolean isSoil(IBlockState state) {
        return soilBlocks.stream().anyMatch(m -> m.test(state));
    }

    public static IBlockExtraDrop getBlockExtraDrop(IBlockState state) {
        return extraBlockDrops.stream().filter(b -> b.matches(state)).findFirst().orElse(EMPTY_EXTRA_DROP);
    }

    static {
        saplings.add(new Sapling(s -> s.func_77973_b() instanceof ItemBlock && ((ItemBlock)s.func_77973_b()).func_179223_d() instanceof BlockSapling, false));
        saplings.add(new Sapling(s -> s.func_77973_b() instanceof ItemBlock && ((ItemBlock)s.func_77973_b()).func_179223_d() instanceof BlockMushroom, false));
        extraBlockDrops.add(new ChorusFlowerDrop());
        TreeFarmRegistry.registerTreeScanner(new ChorusScanner());
        EMPTY_EXTRA_DROP = new IBlockExtraDrop(){

            @Override
            public boolean matches(IBlockState state) {
                return true;
            }

            @Override
            public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
                return NonNullList.func_191196_a();
            }
        };
    }

    public static class TreeScannerParser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "tree_scanners";
        }

        @Override
        public void parse(JsonObject json) {
            JsonArray treeScanners = JsonUtils.func_151214_t((JsonObject)json, (String)"tree_scanners");
            for (JsonElement ts : treeScanners) {
                JsonObject treeScanner = JsonUtils.func_151210_l((JsonElement)ts, (String)"");
                switch (JsonUtils.func_151200_h((JsonObject)treeScanner, (String)"type")) {
                    default: 
                }
                DefaultSearchParser.parse(treeScanner);
            }
        }

        private static class DefaultSearchParser {
            private DefaultSearchParser() {
            }

            public static void parse(JsonObject treeScanner) {
                Predicate<IBlockState> trunkMatcher = JsonHelper.getBlockStateMatcher(treeScanner, "trunks", "trunk");
                Predicate<IBlockState> leafMatcher = JsonHelper.getBlockStateMatcher(treeScanner, "leaves", "leaf");
                int maxLeafDistance = JsonUtils.func_151203_m((JsonObject)treeScanner, (String)"max_leaf_distance");
                DefaultTreeScanner.INextPositionGetter nextPosGetter = DefaultSearchParser.parseNextPositionGetter(treeScanner);
                Optional<DefaultTreeScanner> currentScanner = treeScanners.stream().filter(m -> m instanceof DefaultTreeScanner && ((DefaultTreeScanner)m).getTrunkMatcher().hashCode() == trunkMatcher.hashCode()).map(m -> (DefaultTreeScanner)m).findFirst();
                if (currentScanner.isPresent()) {
                    currentScanner.get().addLeafMatcher(leafMatcher);
                } else {
                    TreeFarmRegistry.registerTreeScanner(new DefaultTreeScanner(trunkMatcher, leafMatcher, nextPosGetter, maxLeafDistance));
                }
            }

            private static DefaultTreeScanner.INextPositionGetter parseNextPositionGetter(JsonObject treeScanner) {
                switch (JsonUtils.func_151200_h((JsonObject)treeScanner, (String)"next_block_search")) {
                    case "all_up_or_level": {
                        return DefaultTreeScanner.ALL_UP_OR_LEVEL;
                    }
                    case "all_around": {
                        return DefaultTreeScanner.ALL_AROUND;
                    }
                    case "connected_around": {
                        return DefaultTreeScanner.CONNECTED_AROUND;
                    }
                    case "connected_down_or_level": {
                        return DefaultTreeScanner.CONNECTED_DOWN_OR_LEVEL;
                    }
                }
                return DefaultTreeScanner.CONNECTED_UP_OR_LEVEL;
            }
        }
    }

    public static class SoilParser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "tree_soil_blocks";
        }

        @Override
        public void parse(JsonObject json) {
            JsonArray soils = JsonUtils.func_151214_t((JsonObject)json, (String)"soils");
            for (JsonElement t : soils) {
                soilBlocks.add(JsonHelper.getBlockStateMatcher(JsonUtils.func_151210_l((JsonElement)t, (String)"")));
            }
        }
    }

    public static class PlantableParser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "saplings";
        }

        @Override
        public void parse(JsonObject json) {
            JsonArray saplings = JsonUtils.func_151214_t((JsonObject)json, (String)"saplings");
            for (JsonElement e : saplings) {
                JsonObject saplingDefinition = JsonUtils.func_151210_l((JsonElement)e, (String)"");
                saplings.add(new Sapling(JsonHelper.getItemStackMatcher((JsonElement)JsonUtils.func_152754_s((JsonObject)saplingDefinition, (String)"sapling")), saplingDefinition.has("right_click") && JsonUtils.func_151212_i((JsonObject)saplingDefinition, (String)"right_click")));
            }
        }
    }
}

