/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.BaseTorqueRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;

public abstract class TorqueTieredRenderer<T extends TileTorqueBase>
extends BaseTorqueRenderer<T> {
    public Map<TorqueTier, TextureAtlasSprite> sprites = Maps.newHashMap();
    public Map<TorqueTier, IconTransformation> iconTransforms = Maps.newHashMap();

    protected TorqueTieredRenderer(String modelPath) {
        super(modelPath);
    }

    public void setSprite(TorqueTier torqueTier, TextureAtlasSprite sprite) {
        this.sprites.put(torqueTier, sprite);
        this.iconTransforms.put(torqueTier, new IconTransformation(sprite));
    }

    @Override
    protected IconTransformation getIconTransform(IExtendedBlockState state) {
        return this.iconTransforms.get(state.func_177229_b(AutomationProperties.TIER));
    }

    @Override
    protected IconTransformation getIconTransform(ItemStack stack) {
        return this.iconTransforms.get((Object)TorqueTier.values()[stack.func_77960_j()]);
    }

    public TextureAtlasSprite getSprite(TorqueTier torqueTier) {
        return this.sprites.get((Object)torqueTier);
    }
}

