/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;

public class TileHandCrankedGenerator
extends TileTorqueSingleCell
implements IWorkSite,
IOwnable {
    private Owner owner = Owner.EMPTY;
    private final ITorque.TorqueCell inputCell;
    private double clientInputEnergy;
    private int clientInputDestEnergy;
    private double inputRotation;
    private double lastInputRotationDiff;

    public TileHandCrankedGenerator() {
        double eff = AWAutomationStatics.low_efficiency_factor;
        this.torqueCell = new ITorque.TorqueCell(0.0, 32.0, 32.0, eff);
        this.inputCell = new ITorque.TorqueCell(32.0, 0.0, 150.0, eff);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.torqueCell.getEnergy() - this.prevEnergy;
            this.balancePower();
            this.torqueOut = this.transferPowerTo(this.getPrimaryFacing());
            this.torqueLoss = this.applyPowerDrain(this.torqueCell);
            this.torqueLoss += this.applyPowerDrain(this.inputCell);
            this.prevEnergy = this.torqueCell.getEnergy();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    private void balancePower() {
        double trans = Math.min(2.0, this.torqueCell.getMaxEnergy() - this.torqueCell.getEnergy());
        trans = Math.min(trans, this.inputCell.getEnergy());
        this.inputCell.setEnergy(this.inputCell.getEnergy() - trans);
        this.torqueCell.setEnergy(this.torqueCell.getEnergy() + trans);
    }

    @Override
    protected void serverNetworkSynch() {
        super.serverNetworkSynch();
        int percent = (int)(this.inputCell.getPercentFull() * 100.0);
        if (percent != this.clientInputDestEnergy) {
            this.clientInputDestEnergy = percent;
            this.sendSideRotation(EnumFacing.UP, percent);
        }
    }

    @Override
    protected void updateRotation() {
        super.updateRotation();
        if (this.clientInputEnergy > 0.0) {
            this.lastInputRotationDiff = -(30.000001907348633 * this.clientInputEnergy * 0.01) * 0.01745329238474369;
            this.inputRotation += this.lastInputRotationDiff;
            this.inputRotation %= 6.2831854820251465;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void clientNetworkUpdate() {
        if (!MathHelper.func_180185_a((float)((float)this.clientEnergyState), (float)this.clientDestEnergyState) || !MathHelper.func_180185_a((float)((float)this.clientInputEnergy), (float)this.clientInputDestEnergy)) {
            if (this.networkUpdateTicks >= 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / ((double)this.networkUpdateTicks + 1.0);
                this.clientInputEnergy += ((double)this.clientInputDestEnergy - this.clientInputEnergy) / ((double)this.networkUpdateTicks + 1.0);
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
                this.clientInputEnergy = this.clientInputDestEnergy;
            }
        }
    }

    @Override
    protected void handleClientRotationData(EnumFacing side, int value) {
        super.handleClientRotationData(side, value);
        if (side == EnumFacing.UP) {
            this.clientInputDestEnergy = value;
        }
    }

    @Override
    public void onBlockBroken(IBlockState state) {
    }

    @Override
    public Set<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public Set<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public boolean hasWork() {
        return this.inputCell.getEnergy() < this.inputCell.getMaxEnergy();
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.inputCell.setEnergy(this.inputCell.getEnergy() + AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType()) * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.inputCell.setEnergy(this.inputCell.getEnergy() + AWCoreStatics.energyPerWorkUnit * AWAutomationStatics.hand_cranked_generator_output);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    @Nullable
    public Team getTeam() {
        return this.field_145850_b.func_96441_U().func_96509_i(this.owner.getName());
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.clientInputDestEnergy = tag.func_74762_e("clientInputDestEnergy");
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74768_a("clientInputDestEnergy", this.clientInputDestEnergy);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.owner = Owner.deserializeFromNBT(tag);
        this.inputCell.setEnergy(tag.func_74769_h("inputEnergy"));
        this.clientInputDestEnergy = tag.func_74762_e("clientInputEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.owner.serializeToNBT(tag);
        tag.func_74780_a("inputEnergy", this.inputCell.getEnergy());
        tag.func_74768_a("clientInputEnergy", this.clientInputDestEnergy);
        return tag;
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        return this.inputCell.getMaxEnergy() + this.torqueCell.getMaxEnergy();
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy();
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        if (from == this.getPrimaryFacing()) {
            return 0.0;
        }
        if (from == EnumFacing.UP || from == null) {
            return this.inputCell.addEnergy(energy);
        }
        return 0.0;
    }

    @Override
    public double drainTorque(EnumFacing from, double energy) {
        if (from == this.getPrimaryFacing()) {
            return this.torqueCell.drainEnergy(energy);
        }
        return 0.0;
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        if (from == this.getPrimaryFacing()) {
            return this.torqueCell.getMaxTickOutput();
        }
        return 0.0;
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        return 0.0;
    }

    @Override
    public boolean canInputTorque(EnumFacing from) {
        return false;
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        float ret = 0.0f;
        if (from == this.getPrimaryFacing()) {
            ret = this.getRenderRotation(this.rotation, this.lastRotationDiff, delta);
        } else if (from == EnumFacing.UP) {
            ret = this.getRenderRotation(this.inputRotation, this.lastInputRotationDiff, delta);
        }
        return ret;
    }

    @Override
    public boolean useOutputRotation(@Nullable EnumFacing from) {
        return true;
    }

    @Override
    protected double getTotalTorque() {
        return this.inputCell.getEnergy() + this.torqueCell.getEnergy();
    }
}

