/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueBase;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;

public abstract class TileTorqueSidedCell
extends TileTorqueBase {
    private static final String CLIENT_ENERGY_TAG = "clientEnergy";
    private boolean[] connections = null;
    final ITorque.SidedTorqueCell[] storage = new ITorque.SidedTorqueCell[DIRECTION_LENGTH];
    private double clientEnergyState;
    private int clientDestEnergyState;
    private double rotation;
    private double lastRotationDiff;

    public TileTorqueSidedCell() {
        double max = this.getMaxTransfer();
        double eff = this.getEfficiency();
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i] = new ITorque.SidedTorqueCell(max, max, max, eff, EnumFacing.values()[i], this);
        }
    }

    protected abstract double getEfficiency();

    protected abstract double getMaxTransfer();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.serverNetworkUpdate();
            this.torqueIn = this.getTotalTorque() - this.prevEnergy;
            this.balanceStorage();
            this.torqueLoss = this.applyPowerLoss();
            this.torqueOut = this.transferPower();
            this.prevEnergy = this.getTotalTorque();
        } else {
            this.clientNetworkUpdate();
            this.updateRotation();
        }
    }

    private double applyPowerLoss() {
        double loss = 0.0;
        for (ITorque.SidedTorqueCell aStorage : this.storage) {
            loss += this.applyPowerDrain(aStorage);
        }
        return loss;
    }

    protected double transferPower() {
        return this.transferPowerTo(this.getPrimaryFacing());
    }

    protected void balanceStorage() {
        int face = this.getPrimaryFacing().ordinal();
        ITorque.SidedTorqueCell out = this.storage[face];
        double total = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            if (i == face) continue;
            total += this.storage[i].getEnergy();
        }
        if (total > 0.0) {
            double transfer = Math.min(total, out.getMaxEnergy() - out.getEnergy());
            double percent = transfer / total;
            transfer = 0.0;
            for (int i = 0; i < this.storage.length; ++i) {
                if (i == face) continue;
                ITorque.SidedTorqueCell in = this.storage[i];
                double fromEach = in.getEnergy() * percent;
                transfer += fromEach;
                in.setEnergy(in.getEnergy() - fromEach);
            }
            out.setEnergy(out.getEnergy() + transfer);
        }
    }

    @Override
    protected void serverNetworkSynch() {
        int percent = (int)(this.storage[this.getPrimaryFacing().ordinal()].getPercentFull() * 100.0);
        int percent2 = (int)(this.torqueOut / this.storage[this.getPrimaryFacing().ordinal()].getMaxOutput() * 100.0);
        if ((percent = Math.max(percent, percent2)) != this.clientDestEnergyState) {
            this.clientDestEnergyState = percent;
            this.sendSideRotation(this.getPrimaryFacing(), percent);
        }
    }

    @Override
    protected void updateRotation() {
        if (this.clientEnergyState > 0.0) {
            this.lastRotationDiff = -(30.000001907348633 * this.clientEnergyState * 0.01) * 0.01745329238474369;
            this.rotation += this.lastRotationDiff;
            this.rotation %= 6.2831854820251465;
        }
    }

    @Override
    protected void clientNetworkUpdate() {
        if (this.clientEnergyState != (double)this.clientDestEnergyState) {
            if (this.networkUpdateTicks > 0) {
                this.clientEnergyState += ((double)this.clientDestEnergyState - this.clientEnergyState) / (double)this.networkUpdateTicks;
                --this.networkUpdateTicks;
            } else {
                this.clientEnergyState = this.clientDestEnergyState;
            }
        }
    }

    @Override
    protected void handleClientRotationData(EnumFacing side, int value) {
        this.clientDestEnergyState = value;
        this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
    }

    @Override
    public boolean canInputTorque(EnumFacing from) {
        return from != this.orientation;
    }

    @Override
    public boolean canOutputTorque(EnumFacing towards) {
        return towards == this.orientation;
    }

    public boolean[] getConnections() {
        if (this.connections == null) {
            this.buildConnections();
        }
        return this.connections;
    }

    @Override
    public void onNeighborTileChanged() {
        super.onNeighborTileChanged();
        this.connections = null;
    }

    private void buildConnections() {
        boolean[] updatedConnections = new boolean[DIRECTION_LENGTH];
        ITorque.ITorqueTile[] cache = this.getTorqueCache();
        for (int i = 0; i < cache.length; ++i) {
            EnumFacing dir = EnumFacing.values()[i];
            if (cache[i] == null) continue;
            updatedConnections[i] = cache[i].canInputTorque(dir.func_176734_d()) && this.canOutputTorque(dir) || cache[i].canOutputTorque(dir.func_176734_d()) && this.canInputTorque(dir);
        }
        if (Loader.isModLoaded((String)"redstoneflux")) {
            TileEntity[] tes = this.getRFCache();
            for (int i = 0; i < tes.length; ++i) {
                if (cache[i] != null || tes[i] == null) continue;
                updatedConnections[i] = true;
            }
        }
        this.connections = updatedConnections;
    }

    @Override
    public double getMaxTorque(@Nullable EnumFacing from) {
        return from == null ? 0.0 : this.storage[from.ordinal()].getMaxEnergy();
    }

    @Override
    public double getTorqueStored(@Nullable EnumFacing from) {
        if (from == null) {
            return 0.0;
        }
        return this.storage[from.ordinal()].getEnergy();
    }

    @Override
    public double addTorque(@Nullable EnumFacing from, double energy) {
        return from == null ? 0.0 : this.storage[from.ordinal()].addEnergy(energy);
    }

    @Override
    public double drainTorque(EnumFacing from, double energy) {
        return this.storage[from.ordinal()].drainEnergy(energy);
    }

    @Override
    public double getMaxTorqueOutput(EnumFacing from) {
        return this.storage[from.ordinal()].getMaxTickOutput();
    }

    @Override
    public double getMaxTorqueInput(@Nullable EnumFacing from) {
        return from == null ? 0.0 : this.storage[from.ordinal()].getMaxTickInput();
    }

    @Override
    public boolean useOutputRotation(@Nullable EnumFacing from) {
        return true;
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        return this.getRenderRotation(this.rotation, this.lastRotationDiff, delta);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74768_a(CLIENT_ENERGY_TAG, this.clientDestEnergyState);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.clientDestEnergyState = tag.func_74762_e(CLIENT_ENERGY_TAG);
        this.connections = null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("energyList", 10);
        for (int i = 0; i < this.storage.length; ++i) {
            this.storage[i].readFromNBT(list.func_150305_b(i));
        }
        this.clientDestEnergyState = tag.func_74762_e(CLIENT_ENERGY_TAG);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (ITorque.SidedTorqueCell aStorage : this.storage) {
            list.func_74742_a((NBTBase)aStorage.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("energyList", (NBTBase)list);
        tag.func_74768_a(CLIENT_ENERGY_TAG, this.clientDestEnergyState);
        return tag;
    }

    @Override
    protected double getTotalTorque() {
        double d = 0.0;
        for (int i = 0; i < this.storage.length; ++i) {
            EnumFacing dir = EnumFacing.values()[i];
            if (!this.canInputTorque(dir) && !this.canOutputTorque(dir)) continue;
            d += this.storage[i].getEnergy();
        }
        return d;
    }
}

